/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.transcripts.types.RedactedAudioResponse;
import com.assemblyai.api.resources.transcripts.types.TranscriptReadyNotification;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public final class TranscriptWebhookNotification {
    private final Object value;
    private final int type;

    private TranscriptWebhookNotification(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((TranscriptReadyNotification)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((RedactedAudioResponse)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TranscriptWebhookNotification && this.equalTo((TranscriptWebhookNotification)other);
    }

    private boolean equalTo(TranscriptWebhookNotification other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static TranscriptWebhookNotification of(TranscriptReadyNotification value) {
        return new TranscriptWebhookNotification(value, 0);
    }

    public static TranscriptWebhookNotification of(RedactedAudioResponse value) {
        return new TranscriptWebhookNotification(value, 1);
    }

    static final class Deserializer
    extends StdDeserializer<TranscriptWebhookNotification> {
        Deserializer() {
            super(TranscriptWebhookNotification.class);
        }

        public TranscriptWebhookNotification deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return TranscriptWebhookNotification.of((TranscriptReadyNotification)ObjectMappers.JSON_MAPPER.convertValue(value, TranscriptReadyNotification.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return TranscriptWebhookNotification.of((RedactedAudioResponse)ObjectMappers.JSON_MAPPER.convertValue(value, RedactedAudioResponse.class));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    throw new JsonParseException(p, "Failed to deserialize");
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(TranscriptReadyNotification var1);

        public T visit(RedactedAudioResponse var1);
    }
}

