/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.transcripts.types.Timestamp;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class AutoHighlightResult {
    private final int count;
    private final double rank;
    private final String text;
    private final List<Timestamp> timestamps;
    private final Map<String, Object> additionalProperties;

    private AutoHighlightResult(int count, double rank, String text, List<Timestamp> timestamps, Map<String, Object> additionalProperties) {
        this.count = count;
        this.rank = rank;
        this.text = text;
        this.timestamps = timestamps;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="count")
    public int getCount() {
        return this.count;
    }

    @JsonProperty(value="rank")
    public double getRank() {
        return this.rank;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="timestamps")
    public List<Timestamp> getTimestamps() {
        return this.timestamps;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AutoHighlightResult && this.equalTo((AutoHighlightResult)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AutoHighlightResult other) {
        return this.count == other.count && this.rank == other.rank && this.text.equals(other.text) && this.timestamps.equals(other.timestamps);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.rank, this.text, this.timestamps);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CountStage,
    RankStage,
    TextStage,
    _FinalStage {
        private int count;
        private double rank;
        private String text;
        private List<Timestamp> timestamps = new ArrayList<Timestamp>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AutoHighlightResult other) {
            this.count(other.getCount());
            this.rank(other.getRank());
            this.text(other.getText());
            this.timestamps(other.getTimestamps());
            return this;
        }

        @Override
        @JsonSetter(value="count")
        public RankStage count(int count) {
            this.count = count;
            return this;
        }

        @Override
        @JsonSetter(value="rank")
        public TextStage rank(double rank) {
            this.rank = rank;
            return this;
        }

        @Override
        @JsonSetter(value="text")
        public _FinalStage text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public _FinalStage addAllTimestamps(List<Timestamp> timestamps) {
            this.timestamps.addAll(timestamps);
            return this;
        }

        @Override
        public _FinalStage addTimestamps(Timestamp timestamps) {
            this.timestamps.add(timestamps);
            return this;
        }

        @Override
        @JsonSetter(value="timestamps", nulls=Nulls.SKIP)
        public _FinalStage timestamps(List<Timestamp> timestamps) {
            this.timestamps.clear();
            this.timestamps.addAll(timestamps);
            return this;
        }

        @Override
        public AutoHighlightResult build() {
            return new AutoHighlightResult(this.count, this.rank, this.text, this.timestamps, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AutoHighlightResult build();

        public _FinalStage timestamps(List<Timestamp> var1);

        public _FinalStage addTimestamps(Timestamp var1);

        public _FinalStage addAllTimestamps(List<Timestamp> var1);
    }

    public static interface TextStage {
        public _FinalStage text(String var1);
    }

    public static interface RankStage {
        public TextStage rank(double var1);
    }

    public static interface CountStage {
        public RankStage count(int var1);

        public Builder from(AutoHighlightResult var1);
    }
}

