/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.lemur.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = LemurQuestionAnswer.Builder.class)
public final class LemurQuestionAnswer {
    private final String question;

    private final String answer;

    private final Map<String, Object> additionalProperties;

    private LemurQuestionAnswer(String question, String answer, Map<String, Object> additionalProperties) {
        this.question = question;
        this.answer = answer;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The question for LeMUR to answer
     */
    @JsonProperty("question")
    public String getQuestion() {
        return question;
    }

    /**
     * @return The answer generated by LeMUR
     */
    @JsonProperty("answer")
    public String getAnswer() {
        return answer;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof LemurQuestionAnswer && equalTo((LemurQuestionAnswer) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LemurQuestionAnswer other) {
        return question.equals(other.question) && answer.equals(other.answer);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.question, this.answer);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static QuestionStage builder() {
        return new Builder();
    }

    public interface QuestionStage {
        AnswerStage question(String question);

        Builder from(LemurQuestionAnswer other);
    }

    public interface AnswerStage {
        _FinalStage answer(String answer);
    }

    public interface _FinalStage {
        LemurQuestionAnswer build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements QuestionStage, AnswerStage, _FinalStage {
        private String question;

        private String answer;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(LemurQuestionAnswer other) {
            question(other.getQuestion());
            answer(other.getAnswer());
            return this;
        }

        /**
         * <p>The question for LeMUR to answer</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("question")
        public AnswerStage question(String question) {
            this.question = question;
            return this;
        }

        /**
         * <p>The answer generated by LeMUR</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("answer")
        public _FinalStage answer(String answer) {
            this.answer = answer;
            return this;
        }

        @java.lang.Override
        public LemurQuestionAnswer build() {
            return new LemurQuestionAnswer(question, answer, additionalProperties);
        }
    }
}
