/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.realtime.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = RealtimeBaseMessage.Builder.class)
public final class RealtimeBaseMessage {
    private final MessageType messageType;

    private final Map<String, Object> additionalProperties;

    private RealtimeBaseMessage(MessageType messageType, Map<String, Object> additionalProperties) {
        this.messageType = messageType;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Describes the type of the message
     */
    @JsonProperty("message_type")
    public MessageType getMessageType() {
        return messageType;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof RealtimeBaseMessage && equalTo((RealtimeBaseMessage) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RealtimeBaseMessage other) {
        return messageType.equals(other.messageType);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.messageType);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MessageTypeStage builder() {
        return new Builder();
    }

    public interface MessageTypeStage {
        _FinalStage messageType(MessageType messageType);

        Builder from(RealtimeBaseMessage other);
    }

    public interface _FinalStage {
        RealtimeBaseMessage build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements MessageTypeStage, _FinalStage {
        private MessageType messageType;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(RealtimeBaseMessage other) {
            messageType(other.getMessageType());
            return this;
        }

        /**
         * <p>Describes the type of the message</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("message_type")
        public _FinalStage messageType(MessageType messageType) {
            this.messageType = messageType;
            return this;
        }

        @java.lang.Override
        public RealtimeBaseMessage build() {
            return new RealtimeBaseMessage(messageType, additionalProperties);
        }
    }
}
