/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.realtime.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = RealtimeTemporaryTokenResponse.Builder.class)
public final class RealtimeTemporaryTokenResponse {
    private final String token;

    private final Map<String, Object> additionalProperties;

    private RealtimeTemporaryTokenResponse(String token, Map<String, Object> additionalProperties) {
        this.token = token;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The temporary authentication token for Streaming Speech-to-Text
     */
    @JsonProperty("token")
    public String getToken() {
        return token;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof RealtimeTemporaryTokenResponse && equalTo((RealtimeTemporaryTokenResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RealtimeTemporaryTokenResponse other) {
        return token.equals(other.token);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.token);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TokenStage builder() {
        return new Builder();
    }

    public interface TokenStage {
        _FinalStage token(String token);

        Builder from(RealtimeTemporaryTokenResponse other);
    }

    public interface _FinalStage {
        RealtimeTemporaryTokenResponse build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TokenStage, _FinalStage {
        private String token;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(RealtimeTemporaryTokenResponse other) {
            token(other.getToken());
            return this;
        }

        /**
         * <p>The temporary authentication token for Streaming Speech-to-Text</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("token")
        public _FinalStage token(String token) {
            this.token = token;
            return this;
        }

        @java.lang.Override
        public RealtimeTemporaryTokenResponse build() {
            return new RealtimeTemporaryTokenResponse(token, additionalProperties);
        }
    }
}
