/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.transcripts.requests;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.transcripts.types.ITranscriptOptionalParams;
import com.assemblyai.api.resources.transcripts.types.PiiPolicy;
import com.assemblyai.api.resources.transcripts.types.RedactPiiAudioQuality;
import com.assemblyai.api.resources.transcripts.types.SpeechModel;
import com.assemblyai.api.resources.transcripts.types.SubstitutionPolicy;
import com.assemblyai.api.resources.transcripts.types.SummaryModel;
import com.assemblyai.api.resources.transcripts.types.SummaryType;
import com.assemblyai.api.resources.transcripts.types.TranscriptBoostParam;
import com.assemblyai.api.resources.transcripts.types.TranscriptCustomSpelling;
import com.assemblyai.api.resources.transcripts.types.TranscriptLanguageCode;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = TranscriptParams.Builder.class)
public final class TranscriptParams implements ITranscriptOptionalParams {
    private final Optional<TranscriptLanguageCode> languageCode;

    private final Optional<Boolean> punctuate;

    private final Optional<Boolean> formatText;

    private final Optional<Boolean> dualChannel;

    private final Optional<SpeechModel> speechModel;

    private final Optional<String> webhookUrl;

    private final Optional<String> webhookAuthHeaderName;

    private final Optional<String> webhookAuthHeaderValue;

    private final Optional<Boolean> autoHighlights;

    private final Optional<Integer> audioStartFrom;

    private final Optional<Integer> audioEndAt;

    private final Optional<List<String>> wordBoost;

    private final Optional<TranscriptBoostParam> boostParam;

    private final Optional<Boolean> filterProfanity;

    private final Optional<Boolean> redactPii;

    private final Optional<Boolean> redactPiiAudio;

    private final Optional<RedactPiiAudioQuality> redactPiiAudioQuality;

    private final Optional<List<PiiPolicy>> redactPiiPolicies;

    private final Optional<SubstitutionPolicy> redactPiiSub;

    private final Optional<Boolean> speakerLabels;

    private final Optional<Integer> speakersExpected;

    private final Optional<Boolean> contentSafety;

    private final Optional<Integer> contentSafetyConfidence;

    private final Optional<Boolean> iabCategories;

    private final Optional<Boolean> languageDetection;

    private final Optional<List<TranscriptCustomSpelling>> customSpelling;

    private final Optional<Boolean> disfluencies;

    private final Optional<Boolean> sentimentAnalysis;

    private final Optional<Boolean> autoChapters;

    private final Optional<Boolean> entityDetection;

    private final Optional<Double> speechThreshold;

    private final Optional<Boolean> summarization;

    private final Optional<SummaryModel> summaryModel;

    private final Optional<SummaryType> summaryType;

    private final Optional<Boolean> customTopics;

    private final Optional<List<String>> topics;

    private final String audioUrl;

    private final Map<String, Object> additionalProperties;

    private TranscriptParams(
            Optional<TranscriptLanguageCode> languageCode,
            Optional<Boolean> punctuate,
            Optional<Boolean> formatText,
            Optional<Boolean> dualChannel,
            Optional<SpeechModel> speechModel,
            Optional<String> webhookUrl,
            Optional<String> webhookAuthHeaderName,
            Optional<String> webhookAuthHeaderValue,
            Optional<Boolean> autoHighlights,
            Optional<Integer> audioStartFrom,
            Optional<Integer> audioEndAt,
            Optional<List<String>> wordBoost,
            Optional<TranscriptBoostParam> boostParam,
            Optional<Boolean> filterProfanity,
            Optional<Boolean> redactPii,
            Optional<Boolean> redactPiiAudio,
            Optional<RedactPiiAudioQuality> redactPiiAudioQuality,
            Optional<List<PiiPolicy>> redactPiiPolicies,
            Optional<SubstitutionPolicy> redactPiiSub,
            Optional<Boolean> speakerLabels,
            Optional<Integer> speakersExpected,
            Optional<Boolean> contentSafety,
            Optional<Integer> contentSafetyConfidence,
            Optional<Boolean> iabCategories,
            Optional<Boolean> languageDetection,
            Optional<List<TranscriptCustomSpelling>> customSpelling,
            Optional<Boolean> disfluencies,
            Optional<Boolean> sentimentAnalysis,
            Optional<Boolean> autoChapters,
            Optional<Boolean> entityDetection,
            Optional<Double> speechThreshold,
            Optional<Boolean> summarization,
            Optional<SummaryModel> summaryModel,
            Optional<SummaryType> summaryType,
            Optional<Boolean> customTopics,
            Optional<List<String>> topics,
            String audioUrl,
            Map<String, Object> additionalProperties) {
        this.languageCode = languageCode;
        this.punctuate = punctuate;
        this.formatText = formatText;
        this.dualChannel = dualChannel;
        this.speechModel = speechModel;
        this.webhookUrl = webhookUrl;
        this.webhookAuthHeaderName = webhookAuthHeaderName;
        this.webhookAuthHeaderValue = webhookAuthHeaderValue;
        this.autoHighlights = autoHighlights;
        this.audioStartFrom = audioStartFrom;
        this.audioEndAt = audioEndAt;
        this.wordBoost = wordBoost;
        this.boostParam = boostParam;
        this.filterProfanity = filterProfanity;
        this.redactPii = redactPii;
        this.redactPiiAudio = redactPiiAudio;
        this.redactPiiAudioQuality = redactPiiAudioQuality;
        this.redactPiiPolicies = redactPiiPolicies;
        this.redactPiiSub = redactPiiSub;
        this.speakerLabels = speakerLabels;
        this.speakersExpected = speakersExpected;
        this.contentSafety = contentSafety;
        this.contentSafetyConfidence = contentSafetyConfidence;
        this.iabCategories = iabCategories;
        this.languageDetection = languageDetection;
        this.customSpelling = customSpelling;
        this.disfluencies = disfluencies;
        this.sentimentAnalysis = sentimentAnalysis;
        this.autoChapters = autoChapters;
        this.entityDetection = entityDetection;
        this.speechThreshold = speechThreshold;
        this.summarization = summarization;
        this.summaryModel = summaryModel;
        this.summaryType = summaryType;
        this.customTopics = customTopics;
        this.topics = topics;
        this.audioUrl = audioUrl;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("language_code")
    @java.lang.Override
    public Optional<TranscriptLanguageCode> getLanguageCode() {
        return languageCode;
    }

    /**
     * @return Enable Automatic Punctuation, can be true or false
     */
    @JsonProperty("punctuate")
    @java.lang.Override
    public Optional<Boolean> getPunctuate() {
        return punctuate;
    }

    /**
     * @return Enable Text Formatting, can be true or false
     */
    @JsonProperty("format_text")
    @java.lang.Override
    public Optional<Boolean> getFormatText() {
        return formatText;
    }

    /**
     * @return Enable <a href="https://www.assemblyai.com/docs/models/speech-recognition#dual-channel-transcription">Dual Channel</a> transcription, can be true or false.
     */
    @JsonProperty("dual_channel")
    @java.lang.Override
    public Optional<Boolean> getDualChannel() {
        return dualChannel;
    }

    @JsonProperty("speech_model")
    @java.lang.Override
    public Optional<SpeechModel> getSpeechModel() {
        return speechModel;
    }

    /**
     * @return The URL to which we send webhook requests. We sends two different types of webhook requests. One request when a transcript is completed or failed, and one request when the redacted audio is ready if redact_pii_audio is enabled.
     */
    @JsonProperty("webhook_url")
    @java.lang.Override
    public Optional<String> getWebhookUrl() {
        return webhookUrl;
    }

    /**
     * @return The header name to be sent with the transcript completed or failed webhook requests
     */
    @JsonProperty("webhook_auth_header_name")
    @java.lang.Override
    public Optional<String> getWebhookAuthHeaderName() {
        return webhookAuthHeaderName;
    }

    /**
     * @return The header value to send back with the transcript completed or failed webhook requests for added security
     */
    @JsonProperty("webhook_auth_header_value")
    @java.lang.Override
    public Optional<String> getWebhookAuthHeaderValue() {
        return webhookAuthHeaderValue;
    }

    /**
     * @return Enable Key Phrases, either true or false
     */
    @JsonProperty("auto_highlights")
    @java.lang.Override
    public Optional<Boolean> getAutoHighlights() {
        return autoHighlights;
    }

    /**
     * @return The point in time, in milliseconds, to begin transcribing in your media file
     */
    @JsonProperty("audio_start_from")
    @java.lang.Override
    public Optional<Integer> getAudioStartFrom() {
        return audioStartFrom;
    }

    /**
     * @return The point in time, in milliseconds, to stop transcribing in your media file
     */
    @JsonProperty("audio_end_at")
    @java.lang.Override
    public Optional<Integer> getAudioEndAt() {
        return audioEndAt;
    }

    /**
     * @return The list of custom vocabulary to boost transcription probability for
     */
    @JsonProperty("word_boost")
    @java.lang.Override
    public Optional<List<String>> getWordBoost() {
        return wordBoost;
    }

    /**
     * @return The word boost parameter value
     */
    @JsonProperty("boost_param")
    @java.lang.Override
    public Optional<TranscriptBoostParam> getBoostParam() {
        return boostParam;
    }

    /**
     * @return Filter profanity from the transcribed text, can be true or false
     */
    @JsonProperty("filter_profanity")
    @java.lang.Override
    public Optional<Boolean> getFilterProfanity() {
        return filterProfanity;
    }

    /**
     * @return Redact PII from the transcribed text using the Redact PII model, can be true or false
     */
    @JsonProperty("redact_pii")
    @java.lang.Override
    public Optional<Boolean> getRedactPii() {
        return redactPii;
    }

    /**
     * @return Generate a copy of the original media file with spoken PII &quot;beeped&quot; out, can be true or false. See <a href="https://www.assemblyai.com/docs/models/pii-redaction">PII redaction</a> for more details.
     */
    @JsonProperty("redact_pii_audio")
    @java.lang.Override
    public Optional<Boolean> getRedactPiiAudio() {
        return redactPiiAudio;
    }

    /**
     * @return Controls the filetype of the audio created by redact_pii_audio. Currently supports mp3 (default) and wav. See <a href="https://www.assemblyai.com/docs/models/pii-redaction">PII redaction</a> for more details.
     */
    @JsonProperty("redact_pii_audio_quality")
    @java.lang.Override
    public Optional<RedactPiiAudioQuality> getRedactPiiAudioQuality() {
        return redactPiiAudioQuality;
    }

    /**
     * @return The list of PII Redaction policies to enable. See <a href="https://www.assemblyai.com/docs/models/pii-redaction">PII redaction</a> for more details.
     */
    @JsonProperty("redact_pii_policies")
    @java.lang.Override
    public Optional<List<PiiPolicy>> getRedactPiiPolicies() {
        return redactPiiPolicies;
    }

    @JsonProperty("redact_pii_sub")
    @java.lang.Override
    public Optional<SubstitutionPolicy> getRedactPiiSub() {
        return redactPiiSub;
    }

    /**
     * @return Enable <a href="https://www.assemblyai.com/docs/models/speaker-diarization">Speaker diarization</a>, can be true or false
     */
    @JsonProperty("speaker_labels")
    @java.lang.Override
    public Optional<Boolean> getSpeakerLabels() {
        return speakerLabels;
    }

    /**
     * @return Tells the speaker label model how many speakers it should attempt to identify, up to 10. See <a href="https://www.assemblyai.com/docs/models/speaker-diarization">Speaker diarization</a> for more details.
     */
    @JsonProperty("speakers_expected")
    @java.lang.Override
    public Optional<Integer> getSpeakersExpected() {
        return speakersExpected;
    }

    /**
     * @return Enable <a href="https://www.assemblyai.com/docs/models/content-moderation">Content Moderation</a>, can be true or false
     */
    @JsonProperty("content_safety")
    @java.lang.Override
    public Optional<Boolean> getContentSafety() {
        return contentSafety;
    }

    /**
     * @return The confidence threshold for the Content Moderation model. Values must be between 25 and 100.
     */
    @JsonProperty("content_safety_confidence")
    @java.lang.Override
    public Optional<Integer> getContentSafetyConfidence() {
        return contentSafetyConfidence;
    }

    /**
     * @return Enable <a href="https://www.assemblyai.com/docs/models/topic-detection">Topic Detection</a>, can be true or false
     */
    @JsonProperty("iab_categories")
    @java.lang.Override
    public Optional<Boolean> getIabCategories() {
        return iabCategories;
    }

    /**
     * @return Enable <a href="https://www.assemblyai.com/docs/models/speech-recognition#automatic-language-detection">Automatic language detection</a>, either true or false.
     */
    @JsonProperty("language_detection")
    @java.lang.Override
    public Optional<Boolean> getLanguageDetection() {
        return languageDetection;
    }

    /**
     * @return Customize how words are spelled and formatted using to and from values
     */
    @JsonProperty("custom_spelling")
    @java.lang.Override
    public Optional<List<TranscriptCustomSpelling>> getCustomSpelling() {
        return customSpelling;
    }

    /**
     * @return Transcribe Filler Words, like &quot;umm&quot;, in your media file; can be true or false
     */
    @JsonProperty("disfluencies")
    @java.lang.Override
    public Optional<Boolean> getDisfluencies() {
        return disfluencies;
    }

    /**
     * @return Enable <a href="https://www.assemblyai.com/docs/models/sentiment-analysis">Sentiment Analysis</a>, can be true or false
     */
    @JsonProperty("sentiment_analysis")
    @java.lang.Override
    public Optional<Boolean> getSentimentAnalysis() {
        return sentimentAnalysis;
    }

    /**
     * @return Enable <a href="https://www.assemblyai.com/docs/models/auto-chapters">Auto Chapters</a>, can be true or false
     */
    @JsonProperty("auto_chapters")
    @java.lang.Override
    public Optional<Boolean> getAutoChapters() {
        return autoChapters;
    }

    /**
     * @return Enable <a href="https://www.assemblyai.com/docs/models/entity-detection">Entity Detection</a>, can be true or false
     */
    @JsonProperty("entity_detection")
    @java.lang.Override
    public Optional<Boolean> getEntityDetection() {
        return entityDetection;
    }

    /**
     * @return Reject audio files that contain less than this fraction of speech.
     * Valid values are in the range [0, 1] inclusive.
     */
    @JsonProperty("speech_threshold")
    @java.lang.Override
    public Optional<Double> getSpeechThreshold() {
        return speechThreshold;
    }

    /**
     * @return Enable <a href="https://www.assemblyai.com/docs/models/summarization">Summarization</a>, can be true or false
     */
    @JsonProperty("summarization")
    @java.lang.Override
    public Optional<Boolean> getSummarization() {
        return summarization;
    }

    /**
     * @return The model to summarize the transcript
     */
    @JsonProperty("summary_model")
    @java.lang.Override
    public Optional<SummaryModel> getSummaryModel() {
        return summaryModel;
    }

    /**
     * @return The type of summary
     */
    @JsonProperty("summary_type")
    @java.lang.Override
    public Optional<SummaryType> getSummaryType() {
        return summaryType;
    }

    /**
     * @return Enable custom topics, either true or false
     */
    @JsonProperty("custom_topics")
    @java.lang.Override
    public Optional<Boolean> getCustomTopics() {
        return customTopics;
    }

    /**
     * @return The list of custom topics
     */
    @JsonProperty("topics")
    @java.lang.Override
    public Optional<List<String>> getTopics() {
        return topics;
    }

    /**
     * @return The URL of the audio or video file to transcribe.
     */
    @JsonProperty("audio_url")
    public String getAudioUrl() {
        return audioUrl;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TranscriptParams && equalTo((TranscriptParams) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TranscriptParams other) {
        return languageCode.equals(other.languageCode)
                && punctuate.equals(other.punctuate)
                && formatText.equals(other.formatText)
                && dualChannel.equals(other.dualChannel)
                && speechModel.equals(other.speechModel)
                && webhookUrl.equals(other.webhookUrl)
                && webhookAuthHeaderName.equals(other.webhookAuthHeaderName)
                && webhookAuthHeaderValue.equals(other.webhookAuthHeaderValue)
                && autoHighlights.equals(other.autoHighlights)
                && audioStartFrom.equals(other.audioStartFrom)
                && audioEndAt.equals(other.audioEndAt)
                && wordBoost.equals(other.wordBoost)
                && boostParam.equals(other.boostParam)
                && filterProfanity.equals(other.filterProfanity)
                && redactPii.equals(other.redactPii)
                && redactPiiAudio.equals(other.redactPiiAudio)
                && redactPiiAudioQuality.equals(other.redactPiiAudioQuality)
                && redactPiiPolicies.equals(other.redactPiiPolicies)
                && redactPiiSub.equals(other.redactPiiSub)
                && speakerLabels.equals(other.speakerLabels)
                && speakersExpected.equals(other.speakersExpected)
                && contentSafety.equals(other.contentSafety)
                && contentSafetyConfidence.equals(other.contentSafetyConfidence)
                && iabCategories.equals(other.iabCategories)
                && languageDetection.equals(other.languageDetection)
                && customSpelling.equals(other.customSpelling)
                && disfluencies.equals(other.disfluencies)
                && sentimentAnalysis.equals(other.sentimentAnalysis)
                && autoChapters.equals(other.autoChapters)
                && entityDetection.equals(other.entityDetection)
                && speechThreshold.equals(other.speechThreshold)
                && summarization.equals(other.summarization)
                && summaryModel.equals(other.summaryModel)
                && summaryType.equals(other.summaryType)
                && customTopics.equals(other.customTopics)
                && topics.equals(other.topics)
                && audioUrl.equals(other.audioUrl);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.languageCode,
                this.punctuate,
                this.formatText,
                this.dualChannel,
                this.speechModel,
                this.webhookUrl,
                this.webhookAuthHeaderName,
                this.webhookAuthHeaderValue,
                this.autoHighlights,
                this.audioStartFrom,
                this.audioEndAt,
                this.wordBoost,
                this.boostParam,
                this.filterProfanity,
                this.redactPii,
                this.redactPiiAudio,
                this.redactPiiAudioQuality,
                this.redactPiiPolicies,
                this.redactPiiSub,
                this.speakerLabels,
                this.speakersExpected,
                this.contentSafety,
                this.contentSafetyConfidence,
                this.iabCategories,
                this.languageDetection,
                this.customSpelling,
                this.disfluencies,
                this.sentimentAnalysis,
                this.autoChapters,
                this.entityDetection,
                this.speechThreshold,
                this.summarization,
                this.summaryModel,
                this.summaryType,
                this.customTopics,
                this.topics,
                this.audioUrl);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AudioUrlStage builder() {
        return new Builder();
    }

    public interface AudioUrlStage {
        _FinalStage audioUrl(String audioUrl);

        Builder from(TranscriptParams other);
    }

    public interface _FinalStage {
        TranscriptParams build();

        _FinalStage languageCode(Optional<TranscriptLanguageCode> languageCode);

        _FinalStage languageCode(TranscriptLanguageCode languageCode);

        _FinalStage punctuate(Optional<Boolean> punctuate);

        _FinalStage punctuate(Boolean punctuate);

        _FinalStage formatText(Optional<Boolean> formatText);

        _FinalStage formatText(Boolean formatText);

        _FinalStage dualChannel(Optional<Boolean> dualChannel);

        _FinalStage dualChannel(Boolean dualChannel);

        _FinalStage speechModel(Optional<SpeechModel> speechModel);

        _FinalStage speechModel(SpeechModel speechModel);

        _FinalStage webhookUrl(Optional<String> webhookUrl);

        _FinalStage webhookUrl(String webhookUrl);

        _FinalStage webhookAuthHeaderName(Optional<String> webhookAuthHeaderName);

        _FinalStage webhookAuthHeaderName(String webhookAuthHeaderName);

        _FinalStage webhookAuthHeaderValue(Optional<String> webhookAuthHeaderValue);

        _FinalStage webhookAuthHeaderValue(String webhookAuthHeaderValue);

        _FinalStage autoHighlights(Optional<Boolean> autoHighlights);

        _FinalStage autoHighlights(Boolean autoHighlights);

        _FinalStage audioStartFrom(Optional<Integer> audioStartFrom);

        _FinalStage audioStartFrom(Integer audioStartFrom);

        _FinalStage audioEndAt(Optional<Integer> audioEndAt);

        _FinalStage audioEndAt(Integer audioEndAt);

        _FinalStage wordBoost(Optional<List<String>> wordBoost);

        _FinalStage wordBoost(List<String> wordBoost);

        _FinalStage boostParam(Optional<TranscriptBoostParam> boostParam);

        _FinalStage boostParam(TranscriptBoostParam boostParam);

        _FinalStage filterProfanity(Optional<Boolean> filterProfanity);

        _FinalStage filterProfanity(Boolean filterProfanity);

        _FinalStage redactPii(Optional<Boolean> redactPii);

        _FinalStage redactPii(Boolean redactPii);

        _FinalStage redactPiiAudio(Optional<Boolean> redactPiiAudio);

        _FinalStage redactPiiAudio(Boolean redactPiiAudio);

        _FinalStage redactPiiAudioQuality(Optional<RedactPiiAudioQuality> redactPiiAudioQuality);

        _FinalStage redactPiiAudioQuality(RedactPiiAudioQuality redactPiiAudioQuality);

        _FinalStage redactPiiPolicies(Optional<List<PiiPolicy>> redactPiiPolicies);

        _FinalStage redactPiiPolicies(List<PiiPolicy> redactPiiPolicies);

        _FinalStage redactPiiSub(Optional<SubstitutionPolicy> redactPiiSub);

        _FinalStage redactPiiSub(SubstitutionPolicy redactPiiSub);

        _FinalStage speakerLabels(Optional<Boolean> speakerLabels);

        _FinalStage speakerLabels(Boolean speakerLabels);

        _FinalStage speakersExpected(Optional<Integer> speakersExpected);

        _FinalStage speakersExpected(Integer speakersExpected);

        _FinalStage contentSafety(Optional<Boolean> contentSafety);

        _FinalStage contentSafety(Boolean contentSafety);

        _FinalStage contentSafetyConfidence(Optional<Integer> contentSafetyConfidence);

        _FinalStage contentSafetyConfidence(Integer contentSafetyConfidence);

        _FinalStage iabCategories(Optional<Boolean> iabCategories);

        _FinalStage iabCategories(Boolean iabCategories);

        _FinalStage languageDetection(Optional<Boolean> languageDetection);

        _FinalStage languageDetection(Boolean languageDetection);

        _FinalStage customSpelling(Optional<List<TranscriptCustomSpelling>> customSpelling);

        _FinalStage customSpelling(List<TranscriptCustomSpelling> customSpelling);

        _FinalStage disfluencies(Optional<Boolean> disfluencies);

        _FinalStage disfluencies(Boolean disfluencies);

        _FinalStage sentimentAnalysis(Optional<Boolean> sentimentAnalysis);

        _FinalStage sentimentAnalysis(Boolean sentimentAnalysis);

        _FinalStage autoChapters(Optional<Boolean> autoChapters);

        _FinalStage autoChapters(Boolean autoChapters);

        _FinalStage entityDetection(Optional<Boolean> entityDetection);

        _FinalStage entityDetection(Boolean entityDetection);

        _FinalStage speechThreshold(Optional<Double> speechThreshold);

        _FinalStage speechThreshold(Double speechThreshold);

        _FinalStage summarization(Optional<Boolean> summarization);

        _FinalStage summarization(Boolean summarization);

        _FinalStage summaryModel(Optional<SummaryModel> summaryModel);

        _FinalStage summaryModel(SummaryModel summaryModel);

        _FinalStage summaryType(Optional<SummaryType> summaryType);

        _FinalStage summaryType(SummaryType summaryType);

        _FinalStage customTopics(Optional<Boolean> customTopics);

        _FinalStage customTopics(Boolean customTopics);

        _FinalStage topics(Optional<List<String>> topics);

        _FinalStage topics(List<String> topics);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements AudioUrlStage, _FinalStage {
        private String audioUrl;

        private Optional<List<String>> topics = Optional.empty();

        private Optional<Boolean> customTopics = Optional.empty();

        private Optional<SummaryType> summaryType = Optional.empty();

        private Optional<SummaryModel> summaryModel = Optional.empty();

        private Optional<Boolean> summarization = Optional.empty();

        private Optional<Double> speechThreshold = Optional.empty();

        private Optional<Boolean> entityDetection = Optional.empty();

        private Optional<Boolean> autoChapters = Optional.empty();

        private Optional<Boolean> sentimentAnalysis = Optional.empty();

        private Optional<Boolean> disfluencies = Optional.empty();

        private Optional<List<TranscriptCustomSpelling>> customSpelling = Optional.empty();

        private Optional<Boolean> languageDetection = Optional.empty();

        private Optional<Boolean> iabCategories = Optional.empty();

        private Optional<Integer> contentSafetyConfidence = Optional.empty();

        private Optional<Boolean> contentSafety = Optional.empty();

        private Optional<Integer> speakersExpected = Optional.empty();

        private Optional<Boolean> speakerLabels = Optional.empty();

        private Optional<SubstitutionPolicy> redactPiiSub = Optional.empty();

        private Optional<List<PiiPolicy>> redactPiiPolicies = Optional.empty();

        private Optional<RedactPiiAudioQuality> redactPiiAudioQuality = Optional.empty();

        private Optional<Boolean> redactPiiAudio = Optional.empty();

        private Optional<Boolean> redactPii = Optional.empty();

        private Optional<Boolean> filterProfanity = Optional.empty();

        private Optional<TranscriptBoostParam> boostParam = Optional.empty();

        private Optional<List<String>> wordBoost = Optional.empty();

        private Optional<Integer> audioEndAt = Optional.empty();

        private Optional<Integer> audioStartFrom = Optional.empty();

        private Optional<Boolean> autoHighlights = Optional.empty();

        private Optional<String> webhookAuthHeaderValue = Optional.empty();

        private Optional<String> webhookAuthHeaderName = Optional.empty();

        private Optional<String> webhookUrl = Optional.empty();

        private Optional<SpeechModel> speechModel = Optional.empty();

        private Optional<Boolean> dualChannel = Optional.empty();

        private Optional<Boolean> formatText = Optional.empty();

        private Optional<Boolean> punctuate = Optional.empty();

        private Optional<TranscriptLanguageCode> languageCode = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TranscriptParams other) {
            languageCode(other.getLanguageCode());
            punctuate(other.getPunctuate());
            formatText(other.getFormatText());
            dualChannel(other.getDualChannel());
            speechModel(other.getSpeechModel());
            webhookUrl(other.getWebhookUrl());
            webhookAuthHeaderName(other.getWebhookAuthHeaderName());
            webhookAuthHeaderValue(other.getWebhookAuthHeaderValue());
            autoHighlights(other.getAutoHighlights());
            audioStartFrom(other.getAudioStartFrom());
            audioEndAt(other.getAudioEndAt());
            wordBoost(other.getWordBoost());
            boostParam(other.getBoostParam());
            filterProfanity(other.getFilterProfanity());
            redactPii(other.getRedactPii());
            redactPiiAudio(other.getRedactPiiAudio());
            redactPiiAudioQuality(other.getRedactPiiAudioQuality());
            redactPiiPolicies(other.getRedactPiiPolicies());
            redactPiiSub(other.getRedactPiiSub());
            speakerLabels(other.getSpeakerLabels());
            speakersExpected(other.getSpeakersExpected());
            contentSafety(other.getContentSafety());
            contentSafetyConfidence(other.getContentSafetyConfidence());
            iabCategories(other.getIabCategories());
            languageDetection(other.getLanguageDetection());
            customSpelling(other.getCustomSpelling());
            disfluencies(other.getDisfluencies());
            sentimentAnalysis(other.getSentimentAnalysis());
            autoChapters(other.getAutoChapters());
            entityDetection(other.getEntityDetection());
            speechThreshold(other.getSpeechThreshold());
            summarization(other.getSummarization());
            summaryModel(other.getSummaryModel());
            summaryType(other.getSummaryType());
            customTopics(other.getCustomTopics());
            topics(other.getTopics());
            audioUrl(other.getAudioUrl());
            return this;
        }

        /**
         * <p>The URL of the audio or video file to transcribe.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("audio_url")
        public _FinalStage audioUrl(String audioUrl) {
            this.audioUrl = audioUrl;
            return this;
        }

        /**
         * <p>The list of custom topics</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage topics(List<String> topics) {
            this.topics = Optional.of(topics);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "topics", nulls = Nulls.SKIP)
        public _FinalStage topics(Optional<List<String>> topics) {
            this.topics = topics;
            return this;
        }

        /**
         * <p>Enable custom topics, either true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage customTopics(Boolean customTopics) {
            this.customTopics = Optional.of(customTopics);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "custom_topics", nulls = Nulls.SKIP)
        public _FinalStage customTopics(Optional<Boolean> customTopics) {
            this.customTopics = customTopics;
            return this;
        }

        /**
         * <p>The type of summary</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage summaryType(SummaryType summaryType) {
            this.summaryType = Optional.of(summaryType);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "summary_type", nulls = Nulls.SKIP)
        public _FinalStage summaryType(Optional<SummaryType> summaryType) {
            this.summaryType = summaryType;
            return this;
        }

        /**
         * <p>The model to summarize the transcript</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage summaryModel(SummaryModel summaryModel) {
            this.summaryModel = Optional.of(summaryModel);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "summary_model", nulls = Nulls.SKIP)
        public _FinalStage summaryModel(Optional<SummaryModel> summaryModel) {
            this.summaryModel = summaryModel;
            return this;
        }

        /**
         * <p>Enable <a href="https://www.assemblyai.com/docs/models/summarization">Summarization</a>, can be true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage summarization(Boolean summarization) {
            this.summarization = Optional.of(summarization);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "summarization", nulls = Nulls.SKIP)
        public _FinalStage summarization(Optional<Boolean> summarization) {
            this.summarization = summarization;
            return this;
        }

        /**
         * <p>Reject audio files that contain less than this fraction of speech.
         * Valid values are in the range [0, 1] inclusive.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage speechThreshold(Double speechThreshold) {
            this.speechThreshold = Optional.of(speechThreshold);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "speech_threshold", nulls = Nulls.SKIP)
        public _FinalStage speechThreshold(Optional<Double> speechThreshold) {
            this.speechThreshold = speechThreshold;
            return this;
        }

        /**
         * <p>Enable <a href="https://www.assemblyai.com/docs/models/entity-detection">Entity Detection</a>, can be true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage entityDetection(Boolean entityDetection) {
            this.entityDetection = Optional.of(entityDetection);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "entity_detection", nulls = Nulls.SKIP)
        public _FinalStage entityDetection(Optional<Boolean> entityDetection) {
            this.entityDetection = entityDetection;
            return this;
        }

        /**
         * <p>Enable <a href="https://www.assemblyai.com/docs/models/auto-chapters">Auto Chapters</a>, can be true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage autoChapters(Boolean autoChapters) {
            this.autoChapters = Optional.of(autoChapters);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "auto_chapters", nulls = Nulls.SKIP)
        public _FinalStage autoChapters(Optional<Boolean> autoChapters) {
            this.autoChapters = autoChapters;
            return this;
        }

        /**
         * <p>Enable <a href="https://www.assemblyai.com/docs/models/sentiment-analysis">Sentiment Analysis</a>, can be true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage sentimentAnalysis(Boolean sentimentAnalysis) {
            this.sentimentAnalysis = Optional.of(sentimentAnalysis);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "sentiment_analysis", nulls = Nulls.SKIP)
        public _FinalStage sentimentAnalysis(Optional<Boolean> sentimentAnalysis) {
            this.sentimentAnalysis = sentimentAnalysis;
            return this;
        }

        /**
         * <p>Transcribe Filler Words, like &quot;umm&quot;, in your media file; can be true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage disfluencies(Boolean disfluencies) {
            this.disfluencies = Optional.of(disfluencies);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "disfluencies", nulls = Nulls.SKIP)
        public _FinalStage disfluencies(Optional<Boolean> disfluencies) {
            this.disfluencies = disfluencies;
            return this;
        }

        /**
         * <p>Customize how words are spelled and formatted using to and from values</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage customSpelling(List<TranscriptCustomSpelling> customSpelling) {
            this.customSpelling = Optional.of(customSpelling);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "custom_spelling", nulls = Nulls.SKIP)
        public _FinalStage customSpelling(Optional<List<TranscriptCustomSpelling>> customSpelling) {
            this.customSpelling = customSpelling;
            return this;
        }

        /**
         * <p>Enable <a href="https://www.assemblyai.com/docs/models/speech-recognition#automatic-language-detection">Automatic language detection</a>, either true or false.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage languageDetection(Boolean languageDetection) {
            this.languageDetection = Optional.of(languageDetection);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "language_detection", nulls = Nulls.SKIP)
        public _FinalStage languageDetection(Optional<Boolean> languageDetection) {
            this.languageDetection = languageDetection;
            return this;
        }

        /**
         * <p>Enable <a href="https://www.assemblyai.com/docs/models/topic-detection">Topic Detection</a>, can be true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage iabCategories(Boolean iabCategories) {
            this.iabCategories = Optional.of(iabCategories);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "iab_categories", nulls = Nulls.SKIP)
        public _FinalStage iabCategories(Optional<Boolean> iabCategories) {
            this.iabCategories = iabCategories;
            return this;
        }

        /**
         * <p>The confidence threshold for the Content Moderation model. Values must be between 25 and 100.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage contentSafetyConfidence(Integer contentSafetyConfidence) {
            this.contentSafetyConfidence = Optional.of(contentSafetyConfidence);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "content_safety_confidence", nulls = Nulls.SKIP)
        public _FinalStage contentSafetyConfidence(Optional<Integer> contentSafetyConfidence) {
            this.contentSafetyConfidence = contentSafetyConfidence;
            return this;
        }

        /**
         * <p>Enable <a href="https://www.assemblyai.com/docs/models/content-moderation">Content Moderation</a>, can be true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage contentSafety(Boolean contentSafety) {
            this.contentSafety = Optional.of(contentSafety);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "content_safety", nulls = Nulls.SKIP)
        public _FinalStage contentSafety(Optional<Boolean> contentSafety) {
            this.contentSafety = contentSafety;
            return this;
        }

        /**
         * <p>Tells the speaker label model how many speakers it should attempt to identify, up to 10. See <a href="https://www.assemblyai.com/docs/models/speaker-diarization">Speaker diarization</a> for more details.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage speakersExpected(Integer speakersExpected) {
            this.speakersExpected = Optional.of(speakersExpected);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "speakers_expected", nulls = Nulls.SKIP)
        public _FinalStage speakersExpected(Optional<Integer> speakersExpected) {
            this.speakersExpected = speakersExpected;
            return this;
        }

        /**
         * <p>Enable <a href="https://www.assemblyai.com/docs/models/speaker-diarization">Speaker diarization</a>, can be true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage speakerLabels(Boolean speakerLabels) {
            this.speakerLabels = Optional.of(speakerLabels);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "speaker_labels", nulls = Nulls.SKIP)
        public _FinalStage speakerLabels(Optional<Boolean> speakerLabels) {
            this.speakerLabels = speakerLabels;
            return this;
        }

        @java.lang.Override
        public _FinalStage redactPiiSub(SubstitutionPolicy redactPiiSub) {
            this.redactPiiSub = Optional.of(redactPiiSub);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "redact_pii_sub", nulls = Nulls.SKIP)
        public _FinalStage redactPiiSub(Optional<SubstitutionPolicy> redactPiiSub) {
            this.redactPiiSub = redactPiiSub;
            return this;
        }

        /**
         * <p>The list of PII Redaction policies to enable. See <a href="https://www.assemblyai.com/docs/models/pii-redaction">PII redaction</a> for more details.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage redactPiiPolicies(List<PiiPolicy> redactPiiPolicies) {
            this.redactPiiPolicies = Optional.of(redactPiiPolicies);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "redact_pii_policies", nulls = Nulls.SKIP)
        public _FinalStage redactPiiPolicies(Optional<List<PiiPolicy>> redactPiiPolicies) {
            this.redactPiiPolicies = redactPiiPolicies;
            return this;
        }

        /**
         * <p>Controls the filetype of the audio created by redact_pii_audio. Currently supports mp3 (default) and wav. See <a href="https://www.assemblyai.com/docs/models/pii-redaction">PII redaction</a> for more details.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage redactPiiAudioQuality(RedactPiiAudioQuality redactPiiAudioQuality) {
            this.redactPiiAudioQuality = Optional.of(redactPiiAudioQuality);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "redact_pii_audio_quality", nulls = Nulls.SKIP)
        public _FinalStage redactPiiAudioQuality(Optional<RedactPiiAudioQuality> redactPiiAudioQuality) {
            this.redactPiiAudioQuality = redactPiiAudioQuality;
            return this;
        }

        /**
         * <p>Generate a copy of the original media file with spoken PII &quot;beeped&quot; out, can be true or false. See <a href="https://www.assemblyai.com/docs/models/pii-redaction">PII redaction</a> for more details.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage redactPiiAudio(Boolean redactPiiAudio) {
            this.redactPiiAudio = Optional.of(redactPiiAudio);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "redact_pii_audio", nulls = Nulls.SKIP)
        public _FinalStage redactPiiAudio(Optional<Boolean> redactPiiAudio) {
            this.redactPiiAudio = redactPiiAudio;
            return this;
        }

        /**
         * <p>Redact PII from the transcribed text using the Redact PII model, can be true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage redactPii(Boolean redactPii) {
            this.redactPii = Optional.of(redactPii);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "redact_pii", nulls = Nulls.SKIP)
        public _FinalStage redactPii(Optional<Boolean> redactPii) {
            this.redactPii = redactPii;
            return this;
        }

        /**
         * <p>Filter profanity from the transcribed text, can be true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage filterProfanity(Boolean filterProfanity) {
            this.filterProfanity = Optional.of(filterProfanity);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_profanity", nulls = Nulls.SKIP)
        public _FinalStage filterProfanity(Optional<Boolean> filterProfanity) {
            this.filterProfanity = filterProfanity;
            return this;
        }

        /**
         * <p>The word boost parameter value</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage boostParam(TranscriptBoostParam boostParam) {
            this.boostParam = Optional.of(boostParam);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "boost_param", nulls = Nulls.SKIP)
        public _FinalStage boostParam(Optional<TranscriptBoostParam> boostParam) {
            this.boostParam = boostParam;
            return this;
        }

        /**
         * <p>The list of custom vocabulary to boost transcription probability for</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage wordBoost(List<String> wordBoost) {
            this.wordBoost = Optional.of(wordBoost);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "word_boost", nulls = Nulls.SKIP)
        public _FinalStage wordBoost(Optional<List<String>> wordBoost) {
            this.wordBoost = wordBoost;
            return this;
        }

        /**
         * <p>The point in time, in milliseconds, to stop transcribing in your media file</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage audioEndAt(Integer audioEndAt) {
            this.audioEndAt = Optional.of(audioEndAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "audio_end_at", nulls = Nulls.SKIP)
        public _FinalStage audioEndAt(Optional<Integer> audioEndAt) {
            this.audioEndAt = audioEndAt;
            return this;
        }

        /**
         * <p>The point in time, in milliseconds, to begin transcribing in your media file</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage audioStartFrom(Integer audioStartFrom) {
            this.audioStartFrom = Optional.of(audioStartFrom);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "audio_start_from", nulls = Nulls.SKIP)
        public _FinalStage audioStartFrom(Optional<Integer> audioStartFrom) {
            this.audioStartFrom = audioStartFrom;
            return this;
        }

        /**
         * <p>Enable Key Phrases, either true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage autoHighlights(Boolean autoHighlights) {
            this.autoHighlights = Optional.of(autoHighlights);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "auto_highlights", nulls = Nulls.SKIP)
        public _FinalStage autoHighlights(Optional<Boolean> autoHighlights) {
            this.autoHighlights = autoHighlights;
            return this;
        }

        /**
         * <p>The header value to send back with the transcript completed or failed webhook requests for added security</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage webhookAuthHeaderValue(String webhookAuthHeaderValue) {
            this.webhookAuthHeaderValue = Optional.of(webhookAuthHeaderValue);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "webhook_auth_header_value", nulls = Nulls.SKIP)
        public _FinalStage webhookAuthHeaderValue(Optional<String> webhookAuthHeaderValue) {
            this.webhookAuthHeaderValue = webhookAuthHeaderValue;
            return this;
        }

        /**
         * <p>The header name to be sent with the transcript completed or failed webhook requests</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage webhookAuthHeaderName(String webhookAuthHeaderName) {
            this.webhookAuthHeaderName = Optional.of(webhookAuthHeaderName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "webhook_auth_header_name", nulls = Nulls.SKIP)
        public _FinalStage webhookAuthHeaderName(Optional<String> webhookAuthHeaderName) {
            this.webhookAuthHeaderName = webhookAuthHeaderName;
            return this;
        }

        /**
         * <p>The URL to which we send webhook requests. We sends two different types of webhook requests. One request when a transcript is completed or failed, and one request when the redacted audio is ready if redact_pii_audio is enabled.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage webhookUrl(String webhookUrl) {
            this.webhookUrl = Optional.of(webhookUrl);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "webhook_url", nulls = Nulls.SKIP)
        public _FinalStage webhookUrl(Optional<String> webhookUrl) {
            this.webhookUrl = webhookUrl;
            return this;
        }

        @java.lang.Override
        public _FinalStage speechModel(SpeechModel speechModel) {
            this.speechModel = Optional.of(speechModel);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "speech_model", nulls = Nulls.SKIP)
        public _FinalStage speechModel(Optional<SpeechModel> speechModel) {
            this.speechModel = speechModel;
            return this;
        }

        /**
         * <p>Enable <a href="https://www.assemblyai.com/docs/models/speech-recognition#dual-channel-transcription">Dual Channel</a> transcription, can be true or false.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage dualChannel(Boolean dualChannel) {
            this.dualChannel = Optional.of(dualChannel);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "dual_channel", nulls = Nulls.SKIP)
        public _FinalStage dualChannel(Optional<Boolean> dualChannel) {
            this.dualChannel = dualChannel;
            return this;
        }

        /**
         * <p>Enable Text Formatting, can be true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage formatText(Boolean formatText) {
            this.formatText = Optional.of(formatText);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "format_text", nulls = Nulls.SKIP)
        public _FinalStage formatText(Optional<Boolean> formatText) {
            this.formatText = formatText;
            return this;
        }

        /**
         * <p>Enable Automatic Punctuation, can be true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage punctuate(Boolean punctuate) {
            this.punctuate = Optional.of(punctuate);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "punctuate", nulls = Nulls.SKIP)
        public _FinalStage punctuate(Optional<Boolean> punctuate) {
            this.punctuate = punctuate;
            return this;
        }

        @java.lang.Override
        public _FinalStage languageCode(TranscriptLanguageCode languageCode) {
            this.languageCode = Optional.of(languageCode);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "language_code", nulls = Nulls.SKIP)
        public _FinalStage languageCode(Optional<TranscriptLanguageCode> languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @java.lang.Override
        public TranscriptParams build() {
            return new TranscriptParams(
                    languageCode,
                    punctuate,
                    formatText,
                    dualChannel,
                    speechModel,
                    webhookUrl,
                    webhookAuthHeaderName,
                    webhookAuthHeaderValue,
                    autoHighlights,
                    audioStartFrom,
                    audioEndAt,
                    wordBoost,
                    boostParam,
                    filterProfanity,
                    redactPii,
                    redactPiiAudio,
                    redactPiiAudioQuality,
                    redactPiiPolicies,
                    redactPiiSub,
                    speakerLabels,
                    speakersExpected,
                    contentSafety,
                    contentSafetyConfidence,
                    iabCategories,
                    languageDetection,
                    customSpelling,
                    disfluencies,
                    sentimentAnalysis,
                    autoChapters,
                    entityDetection,
                    speechThreshold,
                    summarization,
                    summaryModel,
                    summaryType,
                    customTopics,
                    topics,
                    audioUrl,
                    additionalProperties);
        }
    }
}
