/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = AutoHighlightsResult.Builder.class)
public final class AutoHighlightsResult {
    private final AudioIntelligenceModelStatus status;

    private final List<AutoHighlightResult> results;

    private final Map<String, Object> additionalProperties;

    private AutoHighlightsResult(
            AudioIntelligenceModelStatus status,
            List<AutoHighlightResult> results,
            Map<String, Object> additionalProperties) {
        this.status = status;
        this.results = results;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The status of the Key Phrases model. Either success, or unavailable in the rare case that the model failed.
     */
    @JsonProperty("status")
    public AudioIntelligenceModelStatus getStatus() {
        return status;
    }

    /**
     * @return A temporally-sequential array of Key Phrases
     */
    @JsonProperty("results")
    public List<AutoHighlightResult> getResults() {
        return results;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AutoHighlightsResult && equalTo((AutoHighlightsResult) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AutoHighlightsResult other) {
        return status.equals(other.status) && results.equals(other.results);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.status, this.results);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static StatusStage builder() {
        return new Builder();
    }

    public interface StatusStage {
        _FinalStage status(AudioIntelligenceModelStatus status);

        Builder from(AutoHighlightsResult other);
    }

    public interface _FinalStage {
        AutoHighlightsResult build();

        _FinalStage results(List<AutoHighlightResult> results);

        _FinalStage addResults(AutoHighlightResult results);

        _FinalStage addAllResults(List<AutoHighlightResult> results);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements StatusStage, _FinalStage {
        private AudioIntelligenceModelStatus status;

        private List<AutoHighlightResult> results = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(AutoHighlightsResult other) {
            status(other.getStatus());
            results(other.getResults());
            return this;
        }

        /**
         * <p>The status of the Key Phrases model. Either success, or unavailable in the rare case that the model failed.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("status")
        public _FinalStage status(AudioIntelligenceModelStatus status) {
            this.status = status;
            return this;
        }

        /**
         * <p>A temporally-sequential array of Key Phrases</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllResults(List<AutoHighlightResult> results) {
            this.results.addAll(results);
            return this;
        }

        /**
         * <p>A temporally-sequential array of Key Phrases</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addResults(AutoHighlightResult results) {
            this.results.add(results);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "results", nulls = Nulls.SKIP)
        public _FinalStage results(List<AutoHighlightResult> results) {
            this.results.clear();
            this.results.addAll(results);
            return this;
        }

        @java.lang.Override
        public AutoHighlightsResult build() {
            return new AutoHighlightsResult(status, results, additionalProperties);
        }
    }
}
