/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = ParagraphsResponse.Builder.class)
public final class ParagraphsResponse {
    private final String id;

    private final double confidence;

    private final double audioDuration;

    private final List<TranscriptParagraph> paragraphs;

    private final Map<String, Object> additionalProperties;

    private ParagraphsResponse(
            String id,
            double confidence,
            double audioDuration,
            List<TranscriptParagraph> paragraphs,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.confidence = confidence;
        this.audioDuration = audioDuration;
        this.paragraphs = paragraphs;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("confidence")
    public double getConfidence() {
        return confidence;
    }

    @JsonProperty("audio_duration")
    public double getAudioDuration() {
        return audioDuration;
    }

    @JsonProperty("paragraphs")
    public List<TranscriptParagraph> getParagraphs() {
        return paragraphs;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ParagraphsResponse && equalTo((ParagraphsResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ParagraphsResponse other) {
        return id.equals(other.id)
                && confidence == other.confidence
                && audioDuration == other.audioDuration
                && paragraphs.equals(other.paragraphs);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.confidence, this.audioDuration, this.paragraphs);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        ConfidenceStage id(String id);

        Builder from(ParagraphsResponse other);
    }

    public interface ConfidenceStage {
        AudioDurationStage confidence(double confidence);
    }

    public interface AudioDurationStage {
        _FinalStage audioDuration(double audioDuration);
    }

    public interface _FinalStage {
        ParagraphsResponse build();

        _FinalStage paragraphs(List<TranscriptParagraph> paragraphs);

        _FinalStage addParagraphs(TranscriptParagraph paragraphs);

        _FinalStage addAllParagraphs(List<TranscriptParagraph> paragraphs);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, ConfidenceStage, AudioDurationStage, _FinalStage {
        private String id;

        private double confidence;

        private double audioDuration;

        private List<TranscriptParagraph> paragraphs = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ParagraphsResponse other) {
            id(other.getId());
            confidence(other.getConfidence());
            audioDuration(other.getAudioDuration());
            paragraphs(other.getParagraphs());
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public ConfidenceStage id(String id) {
            this.id = id;
            return this;
        }

        @java.lang.Override
        @JsonSetter("confidence")
        public AudioDurationStage confidence(double confidence) {
            this.confidence = confidence;
            return this;
        }

        @java.lang.Override
        @JsonSetter("audio_duration")
        public _FinalStage audioDuration(double audioDuration) {
            this.audioDuration = audioDuration;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllParagraphs(List<TranscriptParagraph> paragraphs) {
            this.paragraphs.addAll(paragraphs);
            return this;
        }

        @java.lang.Override
        public _FinalStage addParagraphs(TranscriptParagraph paragraphs) {
            this.paragraphs.add(paragraphs);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "paragraphs", nulls = Nulls.SKIP)
        public _FinalStage paragraphs(List<TranscriptParagraph> paragraphs) {
            this.paragraphs.clear();
            this.paragraphs.addAll(paragraphs);
            return this;
        }

        @java.lang.Override
        public ParagraphsResponse build() {
            return new ParagraphsResponse(id, confidence, audioDuration, paragraphs, additionalProperties);
        }
    }
}
