/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = RedactedAudioResponse.Builder.class)
public final class RedactedAudioResponse {
    private final String status;

    private final String redactedAudioUrl;

    private final Map<String, Object> additionalProperties;

    private RedactedAudioResponse(String status, String redactedAudioUrl, Map<String, Object> additionalProperties) {
        this.status = status;
        this.redactedAudioUrl = redactedAudioUrl;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The status of the redacted audio
     */
    @JsonProperty("status")
    public String getStatus() {
        return status;
    }

    /**
     * @return The URL of the redacted audio file
     */
    @JsonProperty("redacted_audio_url")
    public String getRedactedAudioUrl() {
        return redactedAudioUrl;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof RedactedAudioResponse && equalTo((RedactedAudioResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RedactedAudioResponse other) {
        return status.equals(other.status) && redactedAudioUrl.equals(other.redactedAudioUrl);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.status, this.redactedAudioUrl);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static StatusStage builder() {
        return new Builder();
    }

    public interface StatusStage {
        RedactedAudioUrlStage status(String status);

        Builder from(RedactedAudioResponse other);
    }

    public interface RedactedAudioUrlStage {
        _FinalStage redactedAudioUrl(String redactedAudioUrl);
    }

    public interface _FinalStage {
        RedactedAudioResponse build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements StatusStage, RedactedAudioUrlStage, _FinalStage {
        private String status;

        private String redactedAudioUrl;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(RedactedAudioResponse other) {
            status(other.getStatus());
            redactedAudioUrl(other.getRedactedAudioUrl());
            return this;
        }

        /**
         * <p>The status of the redacted audio</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("status")
        public RedactedAudioUrlStage status(String status) {
            this.status = status;
            return this;
        }

        /**
         * <p>The URL of the redacted audio file</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("redacted_audio_url")
        public _FinalStage redactedAudioUrl(String redactedAudioUrl) {
            this.redactedAudioUrl = redactedAudioUrl;
            return this;
        }

        @java.lang.Override
        public RedactedAudioResponse build() {
            return new RedactedAudioResponse(status, redactedAudioUrl, additionalProperties);
        }
    }
}
