/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = SentimentAnalysisResult.Builder.class)
public final class SentimentAnalysisResult {
    private final String text;

    private final int start;

    private final int end;

    private final Sentiment sentiment;

    private final double confidence;

    private final Optional<String> speaker;

    private final Map<String, Object> additionalProperties;

    private SentimentAnalysisResult(
            String text,
            int start,
            int end,
            Sentiment sentiment,
            double confidence,
            Optional<String> speaker,
            Map<String, Object> additionalProperties) {
        this.text = text;
        this.start = start;
        this.end = end;
        this.sentiment = sentiment;
        this.confidence = confidence;
        this.speaker = speaker;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The transcript of the sentence
     */
    @JsonProperty("text")
    public String getText() {
        return text;
    }

    /**
     * @return The starting time, in milliseconds, of the sentence
     */
    @JsonProperty("start")
    public int getStart() {
        return start;
    }

    /**
     * @return The ending time, in milliseconds, of the sentence
     */
    @JsonProperty("end")
    public int getEnd() {
        return end;
    }

    /**
     * @return The detected sentiment for the sentence, one of POSITIVE, NEUTRAL, NEGATIVE
     */
    @JsonProperty("sentiment")
    public Sentiment getSentiment() {
        return sentiment;
    }

    /**
     * @return The confidence score for the detected sentiment of the sentence, from 0 to 1
     */
    @JsonProperty("confidence")
    public double getConfidence() {
        return confidence;
    }

    /**
     * @return The speaker of the sentence if <a href="https://www.assemblyai.com/docs/models/speaker-diarization">Speaker Diarization</a> is enabled, else null
     */
    @JsonProperty("speaker")
    public Optional<String> getSpeaker() {
        return speaker;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SentimentAnalysisResult && equalTo((SentimentAnalysisResult) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SentimentAnalysisResult other) {
        return text.equals(other.text)
                && start == other.start
                && end == other.end
                && sentiment.equals(other.sentiment)
                && confidence == other.confidence
                && speaker.equals(other.speaker);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.text, this.start, this.end, this.sentiment, this.confidence, this.speaker);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TextStage builder() {
        return new Builder();
    }

    public interface TextStage {
        StartStage text(String text);

        Builder from(SentimentAnalysisResult other);
    }

    public interface StartStage {
        EndStage start(int start);
    }

    public interface EndStage {
        SentimentStage end(int end);
    }

    public interface SentimentStage {
        ConfidenceStage sentiment(Sentiment sentiment);
    }

    public interface ConfidenceStage {
        _FinalStage confidence(double confidence);
    }

    public interface _FinalStage {
        SentimentAnalysisResult build();

        _FinalStage speaker(Optional<String> speaker);

        _FinalStage speaker(String speaker);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements TextStage, StartStage, EndStage, SentimentStage, ConfidenceStage, _FinalStage {
        private String text;

        private int start;

        private int end;

        private Sentiment sentiment;

        private double confidence;

        private Optional<String> speaker = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(SentimentAnalysisResult other) {
            text(other.getText());
            start(other.getStart());
            end(other.getEnd());
            sentiment(other.getSentiment());
            confidence(other.getConfidence());
            speaker(other.getSpeaker());
            return this;
        }

        /**
         * <p>The transcript of the sentence</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("text")
        public StartStage text(String text) {
            this.text = text;
            return this;
        }

        /**
         * <p>The starting time, in milliseconds, of the sentence</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("start")
        public EndStage start(int start) {
            this.start = start;
            return this;
        }

        /**
         * <p>The ending time, in milliseconds, of the sentence</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("end")
        public SentimentStage end(int end) {
            this.end = end;
            return this;
        }

        /**
         * <p>The detected sentiment for the sentence, one of POSITIVE, NEUTRAL, NEGATIVE</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("sentiment")
        public ConfidenceStage sentiment(Sentiment sentiment) {
            this.sentiment = sentiment;
            return this;
        }

        /**
         * <p>The confidence score for the detected sentiment of the sentence, from 0 to 1</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("confidence")
        public _FinalStage confidence(double confidence) {
            this.confidence = confidence;
            return this;
        }

        /**
         * <p>The speaker of the sentence if <a href="https://www.assemblyai.com/docs/models/speaker-diarization">Speaker Diarization</a> is enabled, else null</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage speaker(String speaker) {
            this.speaker = Optional.of(speaker);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "speaker", nulls = Nulls.SKIP)
        public _FinalStage speaker(Optional<String> speaker) {
            this.speaker = speaker;
            return this;
        }

        @java.lang.Override
        public SentimentAnalysisResult build() {
            return new SentimentAnalysisResult(text, start, end, sentiment, confidence, speaker, additionalProperties);
        }
    }
}
