/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = Timestamp.Builder.class)
public final class Timestamp {
    private final int start;

    private final int end;

    private final Map<String, Object> additionalProperties;

    private Timestamp(int start, int end, Map<String, Object> additionalProperties) {
        this.start = start;
        this.end = end;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The start time in milliseconds
     */
    @JsonProperty("start")
    public int getStart() {
        return start;
    }

    /**
     * @return The end time in milliseconds
     */
    @JsonProperty("end")
    public int getEnd() {
        return end;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Timestamp && equalTo((Timestamp) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Timestamp other) {
        return start == other.start && end == other.end;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static StartStage builder() {
        return new Builder();
    }

    public interface StartStage {
        EndStage start(int start);

        Builder from(Timestamp other);
    }

    public interface EndStage {
        _FinalStage end(int end);
    }

    public interface _FinalStage {
        Timestamp build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements StartStage, EndStage, _FinalStage {
        private int start;

        private int end;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Timestamp other) {
            start(other.getStart());
            end(other.getEnd());
            return this;
        }

        /**
         * <p>The start time in milliseconds</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("start")
        public EndStage start(int start) {
            this.start = start;
            return this;
        }

        /**
         * <p>The end time in milliseconds</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("end")
        public _FinalStage end(int end) {
            this.end = end;
            return this;
        }

        @java.lang.Override
        public Timestamp build() {
            return new Timestamp(start, end, additionalProperties);
        }
    }
}
