/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = TopicDetectionResult.Builder.class)
public final class TopicDetectionResult {
    private final String text;

    private final Optional<List<TopicDetectionResultLabelsItem>> labels;

    private final Optional<Timestamp> timestamp;

    private final Map<String, Object> additionalProperties;

    private TopicDetectionResult(
            String text,
            Optional<List<TopicDetectionResultLabelsItem>> labels,
            Optional<Timestamp> timestamp,
            Map<String, Object> additionalProperties) {
        this.text = text;
        this.labels = labels;
        this.timestamp = timestamp;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The text in the transcript in which a detected topic occurs
     */
    @JsonProperty("text")
    public String getText() {
        return text;
    }

    @JsonProperty("labels")
    public Optional<List<TopicDetectionResultLabelsItem>> getLabels() {
        return labels;
    }

    @JsonProperty("timestamp")
    public Optional<Timestamp> getTimestamp() {
        return timestamp;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TopicDetectionResult && equalTo((TopicDetectionResult) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TopicDetectionResult other) {
        return text.equals(other.text) && labels.equals(other.labels) && timestamp.equals(other.timestamp);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.text, this.labels, this.timestamp);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TextStage builder() {
        return new Builder();
    }

    public interface TextStage {
        _FinalStage text(String text);

        Builder from(TopicDetectionResult other);
    }

    public interface _FinalStage {
        TopicDetectionResult build();

        _FinalStage labels(Optional<List<TopicDetectionResultLabelsItem>> labels);

        _FinalStage labels(List<TopicDetectionResultLabelsItem> labels);

        _FinalStage timestamp(Optional<Timestamp> timestamp);

        _FinalStage timestamp(Timestamp timestamp);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TextStage, _FinalStage {
        private String text;

        private Optional<Timestamp> timestamp = Optional.empty();

        private Optional<List<TopicDetectionResultLabelsItem>> labels = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TopicDetectionResult other) {
            text(other.getText());
            labels(other.getLabels());
            timestamp(other.getTimestamp());
            return this;
        }

        /**
         * <p>The text in the transcript in which a detected topic occurs</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("text")
        public _FinalStage text(String text) {
            this.text = text;
            return this;
        }

        @java.lang.Override
        public _FinalStage timestamp(Timestamp timestamp) {
            this.timestamp = Optional.of(timestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "timestamp", nulls = Nulls.SKIP)
        public _FinalStage timestamp(Optional<Timestamp> timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage labels(List<TopicDetectionResultLabelsItem> labels) {
            this.labels = Optional.of(labels);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "labels", nulls = Nulls.SKIP)
        public _FinalStage labels(Optional<List<TopicDetectionResultLabelsItem>> labels) {
            this.labels = labels;
            return this;
        }

        @java.lang.Override
        public TopicDetectionResult build() {
            return new TopicDetectionResult(text, labels, timestamp, additionalProperties);
        }
    }
}
