/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class TranscriptStatus {
    public static final TranscriptStatus COMPLETED = new TranscriptStatus(Value.COMPLETED, "completed");

    public static final TranscriptStatus ERROR = new TranscriptStatus(Value.ERROR, "error");

    public static final TranscriptStatus QUEUED = new TranscriptStatus(Value.QUEUED, "queued");

    public static final TranscriptStatus PROCESSING = new TranscriptStatus(Value.PROCESSING, "processing");

    private final Value value;

    private final String string;

    TranscriptStatus(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return value;
    }

    @java.lang.Override
    @JsonValue
    public String toString() {
        return this.string;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        return (this == other)
                || (other instanceof TranscriptStatus && this.string.equals(((TranscriptStatus) other).string));
    }

    @java.lang.Override
    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (value) {
            case COMPLETED:
                return visitor.visitCompleted();
            case ERROR:
                return visitor.visitError();
            case QUEUED:
                return visitor.visitQueued();
            case PROCESSING:
                return visitor.visitProcessing();
            case UNKNOWN:
            default:
                return visitor.visitUnknown(string);
        }
    }

    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    public static TranscriptStatus valueOf(String value) {
        switch (value) {
            case "completed":
                return COMPLETED;
            case "error":
                return ERROR;
            case "queued":
                return QUEUED;
            case "processing":
                return PROCESSING;
            default:
                return new TranscriptStatus(Value.UNKNOWN, value);
        }
    }

    public enum Value {
        QUEUED,

        PROCESSING,

        COMPLETED,

        ERROR,

        UNKNOWN
    }

    public interface Visitor<T> {
        T visitQueued();

        T visitProcessing();

        T visitCompleted();

        T visitError();

        T visitUnknown(String unknownType);
    }
}
