/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = WordSearchResponse.Builder.class)
public final class WordSearchResponse {
    private final String id;

    private final int totalCount;

    private final List<WordSearchMatch> matches;

    private final Map<String, Object> additionalProperties;

    private WordSearchResponse(
            String id, int totalCount, List<WordSearchMatch> matches, Map<String, Object> additionalProperties) {
        this.id = id;
        this.totalCount = totalCount;
        this.matches = matches;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The ID of the transcript
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The total count of all matched instances. For e.g., word 1 matched 2 times, and word 2 matched 3 times, <code>total_count</code> will equal 5.
     */
    @JsonProperty("total_count")
    public int getTotalCount() {
        return totalCount;
    }

    /**
     * @return The matches of the search
     */
    @JsonProperty("matches")
    public List<WordSearchMatch> getMatches() {
        return matches;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof WordSearchResponse && equalTo((WordSearchResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(WordSearchResponse other) {
        return id.equals(other.id) && totalCount == other.totalCount && matches.equals(other.matches);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.totalCount, this.matches);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        TotalCountStage id(String id);

        Builder from(WordSearchResponse other);
    }

    public interface TotalCountStage {
        _FinalStage totalCount(int totalCount);
    }

    public interface _FinalStage {
        WordSearchResponse build();

        _FinalStage matches(List<WordSearchMatch> matches);

        _FinalStage addMatches(WordSearchMatch matches);

        _FinalStage addAllMatches(List<WordSearchMatch> matches);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, TotalCountStage, _FinalStage {
        private String id;

        private int totalCount;

        private List<WordSearchMatch> matches = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(WordSearchResponse other) {
            id(other.getId());
            totalCount(other.getTotalCount());
            matches(other.getMatches());
            return this;
        }

        /**
         * <p>The ID of the transcript</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public TotalCountStage id(String id) {
            this.id = id;
            return this;
        }

        /**
         * <p>The total count of all matched instances. For e.g., word 1 matched 2 times, and word 2 matched 3 times, <code>total_count</code> will equal 5.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        /**
         * <p>The matches of the search</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllMatches(List<WordSearchMatch> matches) {
            this.matches.addAll(matches);
            return this;
        }

        /**
         * <p>The matches of the search</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addMatches(WordSearchMatch matches) {
            this.matches.add(matches);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "matches", nulls = Nulls.SKIP)
        public _FinalStage matches(List<WordSearchMatch> matches) {
            this.matches.clear();
            this.matches.addAll(matches);
            return this;
        }

        @java.lang.Override
        public WordSearchResponse build() {
            return new WordSearchResponse(id, totalCount, matches, additionalProperties);
        }
    }
}
