/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.lemur.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.lemur.types.ILemurStringResponse;
import com.assemblyai.api.resources.lemur.types.LemurUsage;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class LemurActionItemsResponse
implements ILemurStringResponse {
    private final String response;
    private final String requestId;
    private final LemurUsage usage;
    private final Map<String, Object> additionalProperties;

    private LemurActionItemsResponse(String response, String requestId, LemurUsage usage, Map<String, Object> additionalProperties) {
        this.response = response;
        this.requestId = requestId;
        this.usage = usage;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="response")
    public String getResponse() {
        return this.response;
    }

    @Override
    @JsonProperty(value="request_id")
    public String getRequestId() {
        return this.requestId;
    }

    @Override
    @JsonProperty(value="usage")
    public LemurUsage getUsage() {
        return this.usage;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LemurActionItemsResponse && this.equalTo((LemurActionItemsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LemurActionItemsResponse other) {
        return this.response.equals(other.response) && this.requestId.equals(other.requestId) && this.usage.equals(other.usage);
    }

    public int hashCode() {
        return Objects.hash(this.response, this.requestId, this.usage);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ResponseStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ResponseStage,
    RequestIdStage,
    UsageStage,
    _FinalStage {
        private String response;
        private String requestId;
        private LemurUsage usage;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LemurActionItemsResponse other) {
            this.response(other.getResponse());
            this.requestId(other.getRequestId());
            this.usage(other.getUsage());
            return this;
        }

        @Override
        @JsonSetter(value="response")
        public RequestIdStage response(String response) {
            this.response = response;
            return this;
        }

        @Override
        @JsonSetter(value="request_id")
        public UsageStage requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        @JsonSetter(value="usage")
        public _FinalStage usage(LemurUsage usage) {
            this.usage = usage;
            return this;
        }

        @Override
        public LemurActionItemsResponse build() {
            return new LemurActionItemsResponse(this.response, this.requestId, this.usage, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LemurActionItemsResponse build();
    }

    public static interface UsageStage {
        public _FinalStage usage(LemurUsage var1);
    }

    public static interface RequestIdStage {
        public UsageStage requestId(String var1);
    }

    public static interface ResponseStage {
        public RequestIdStage response(String var1);

        public Builder from(LemurActionItemsResponse var1);
    }
}

