/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.lemur.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public final class LemurBaseParamsContext {
    private final Object value;
    private final int type;

    private LemurBaseParamsContext(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((String)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((Map)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LemurBaseParamsContext && this.equalTo((LemurBaseParamsContext)other);
    }

    private boolean equalTo(LemurBaseParamsContext other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static LemurBaseParamsContext of(String value) {
        return new LemurBaseParamsContext(value, 0);
    }

    public static LemurBaseParamsContext of(Map<String, Object> value) {
        return new LemurBaseParamsContext(value, 1);
    }

    static final class Deserializer
    extends StdDeserializer<LemurBaseParamsContext> {
        Deserializer() {
            super(LemurBaseParamsContext.class);
        }

        public LemurBaseParamsContext deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return LemurBaseParamsContext.of((String)ObjectMappers.JSON_MAPPER.convertValue(value, String.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return LemurBaseParamsContext.of((Map)ObjectMappers.JSON_MAPPER.convertValue(value, (TypeReference)new TypeReference<Map<String, Object>>(){}));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    throw new JsonParseException(p, "Failed to deserialize");
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(String var1);

        public T visit(Map<String, Object> var1);
    }
}

