/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.lemur.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class LemurModel {
    public static final LemurModel DEFAULT = new LemurModel(Value.DEFAULT, "default");
    public static final LemurModel ANTHROPIC_CLAUDE2 = new LemurModel(Value.ANTHROPIC_CLAUDE2, "anthropic/claude-2");
    public static final LemurModel ANTHROPIC_CLAUDE3_SONNET = new LemurModel(Value.ANTHROPIC_CLAUDE3_SONNET, "anthropic/claude-3-sonnet");
    public static final LemurModel ASSEMBLYAI_MISTRAL7B = new LemurModel(Value.ASSEMBLYAI_MISTRAL7B, "assemblyai/mistral-7b");
    public static final LemurModel ANTHROPIC_CLAUDE3_5_SONNET = new LemurModel(Value.ANTHROPIC_CLAUDE3_5_SONNET, "anthropic/claude-3-5-sonnet");
    public static final LemurModel ANTHROPIC_CLAUDE3_HAIKU = new LemurModel(Value.ANTHROPIC_CLAUDE3_HAIKU, "anthropic/claude-3-haiku");
    public static final LemurModel BASIC = new LemurModel(Value.BASIC, "basic");
    public static final LemurModel ANTHROPIC_CLAUDE3_OPUS = new LemurModel(Value.ANTHROPIC_CLAUDE3_OPUS, "anthropic/claude-3-opus");
    public static final LemurModel ANTHROPIC_CLAUDE2_1 = new LemurModel(Value.ANTHROPIC_CLAUDE2_1, "anthropic/claude-2-1");
    public static final LemurModel ANTHROPIC_CLAUDE_INSTANT1_2 = new LemurModel(Value.ANTHROPIC_CLAUDE_INSTANT1_2, "anthropic/claude-instant-1-2");
    private final Value value;
    private final String string;

    LemurModel(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof LemurModel && this.string.equals(((LemurModel)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case DEFAULT: {
                return visitor.visitDefault();
            }
            case ANTHROPIC_CLAUDE2: {
                return visitor.visitAnthropicClaude2();
            }
            case ANTHROPIC_CLAUDE3_SONNET: {
                return visitor.visitAnthropicClaude3_Sonnet();
            }
            case ASSEMBLYAI_MISTRAL7B: {
                return visitor.visitAssemblyaiMistral7b();
            }
            case ANTHROPIC_CLAUDE3_5_SONNET: {
                return visitor.visitAnthropicClaude3_5_Sonnet();
            }
            case ANTHROPIC_CLAUDE3_HAIKU: {
                return visitor.visitAnthropicClaude3_Haiku();
            }
            case BASIC: {
                return visitor.visitBasic();
            }
            case ANTHROPIC_CLAUDE3_OPUS: {
                return visitor.visitAnthropicClaude3_Opus();
            }
            case ANTHROPIC_CLAUDE2_1: {
                return visitor.visitAnthropicClaude2_1();
            }
            case ANTHROPIC_CLAUDE_INSTANT1_2: {
                return visitor.visitAnthropicClaudeInstant1_2();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static LemurModel valueOf(String value) {
        switch (value) {
            case "default": {
                return DEFAULT;
            }
            case "anthropic/claude-2": {
                return ANTHROPIC_CLAUDE2;
            }
            case "anthropic/claude-3-sonnet": {
                return ANTHROPIC_CLAUDE3_SONNET;
            }
            case "assemblyai/mistral-7b": {
                return ASSEMBLYAI_MISTRAL7B;
            }
            case "anthropic/claude-3-5-sonnet": {
                return ANTHROPIC_CLAUDE3_5_SONNET;
            }
            case "anthropic/claude-3-haiku": {
                return ANTHROPIC_CLAUDE3_HAIKU;
            }
            case "basic": {
                return BASIC;
            }
            case "anthropic/claude-3-opus": {
                return ANTHROPIC_CLAUDE3_OPUS;
            }
            case "anthropic/claude-2-1": {
                return ANTHROPIC_CLAUDE2_1;
            }
            case "anthropic/claude-instant-1-2": {
                return ANTHROPIC_CLAUDE_INSTANT1_2;
            }
        }
        return new LemurModel(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitAnthropicClaude3_5_Sonnet();

        public T visitAnthropicClaude3_Opus();

        public T visitAnthropicClaude3_Haiku();

        public T visitAnthropicClaude3_Sonnet();

        public T visitAnthropicClaude2_1();

        public T visitAnthropicClaude2();

        public T visitDefault();

        public T visitAnthropicClaudeInstant1_2();

        public T visitBasic();

        public T visitAssemblyaiMistral7b();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        ANTHROPIC_CLAUDE3_5_SONNET,
        ANTHROPIC_CLAUDE3_OPUS,
        ANTHROPIC_CLAUDE3_HAIKU,
        ANTHROPIC_CLAUDE3_SONNET,
        ANTHROPIC_CLAUDE2_1,
        ANTHROPIC_CLAUDE2,
        DEFAULT,
        ANTHROPIC_CLAUDE_INSTANT1_2,
        BASIC,
        ASSEMBLYAI_MISTRAL7B,
        UNKNOWN;

    }
}

