/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.realtime.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.realtime.types.IRealtimeBaseTranscript;
import com.assemblyai.api.resources.realtime.types.Word;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class FinalTranscript
implements IRealtimeBaseTranscript {
    private final int audioStart;
    private final int audioEnd;
    private final double confidence;
    private final String text;
    private final List<Word> words;
    private final OffsetDateTime created;
    private final boolean punctuated;
    private final boolean textFormatted;
    private final Map<String, Object> additionalProperties;

    private FinalTranscript(String messageType, int audioStart, int audioEnd, double confidence, String text, List<Word> words, OffsetDateTime created, boolean punctuated, boolean textFormatted, Map<String, Object> additionalProperties) {
        if (!messageType.equals("FinalTranscript")) {
            throw new IllegalArgumentException("messageType must be FinalTranscript");
        }
        this.audioStart = audioStart;
        this.audioEnd = audioEnd;
        this.confidence = confidence;
        this.text = text;
        this.words = words;
        this.created = created;
        this.punctuated = punctuated;
        this.textFormatted = textFormatted;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="audio_start")
    public int getAudioStart() {
        return this.audioStart;
    }

    @Override
    @JsonProperty(value="audio_end")
    public int getAudioEnd() {
        return this.audioEnd;
    }

    @Override
    @JsonProperty(value="confidence")
    public double getConfidence() {
        return this.confidence;
    }

    @Override
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @Override
    @JsonProperty(value="words")
    public List<Word> getWords() {
        return this.words;
    }

    @Override
    @JsonProperty(value="created")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @JsonProperty(value="message_type")
    public String getMessageType() {
        return "FinalTranscript";
    }

    @JsonProperty(value="punctuated")
    public boolean getPunctuated() {
        return this.punctuated;
    }

    @JsonProperty(value="text_formatted")
    public boolean getTextFormatted() {
        return this.textFormatted;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FinalTranscript && this.equalTo((FinalTranscript)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FinalTranscript other) {
        return this.audioStart == other.audioStart && this.audioEnd == other.audioEnd && this.confidence == other.confidence && this.text.equals(other.text) && this.words.equals(other.words) && this.created.equals(other.created) && this.punctuated == other.punctuated && this.textFormatted == other.textFormatted;
    }

    public int hashCode() {
        return Objects.hash(this.audioStart, this.audioEnd, this.confidence, this.text, this.words, this.created, this.punctuated, this.textFormatted);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AudioStartStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AudioStartStage,
    AudioEndStage,
    ConfidenceStage,
    TextStage,
    CreatedStage,
    PunctuatedStage,
    TextFormattedStage,
    _FinalStage {
        @JsonSetter(value="message_type")
        private String messageType = "FinalTranscript";
        private int audioStart;
        private int audioEnd;
        private double confidence;
        private String text;
        private OffsetDateTime created;
        private boolean punctuated;
        private boolean textFormatted;
        private List<Word> words = new ArrayList<Word>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(FinalTranscript other) {
            this.audioStart(other.getAudioStart());
            this.audioEnd(other.getAudioEnd());
            this.confidence(other.getConfidence());
            this.text(other.getText());
            this.words(other.getWords());
            this.created(other.getCreated());
            this.punctuated(other.getPunctuated());
            this.textFormatted(other.getTextFormatted());
            return this;
        }

        @Override
        @JsonSetter(value="audio_start")
        public AudioEndStage audioStart(int audioStart) {
            this.audioStart = audioStart;
            return this;
        }

        @Override
        @JsonSetter(value="audio_end")
        public ConfidenceStage audioEnd(int audioEnd) {
            this.audioEnd = audioEnd;
            return this;
        }

        @Override
        @JsonSetter(value="confidence")
        public TextStage confidence(double confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        @JsonSetter(value="text")
        public CreatedStage text(String text) {
            this.text = text;
            return this;
        }

        @Override
        @JsonSetter(value="created")
        public PunctuatedStage created(OffsetDateTime created) {
            this.created = created;
            return this;
        }

        @Override
        @JsonSetter(value="punctuated")
        public TextFormattedStage punctuated(boolean punctuated) {
            this.punctuated = punctuated;
            return this;
        }

        @Override
        @JsonSetter(value="text_formatted")
        public _FinalStage textFormatted(boolean textFormatted) {
            this.textFormatted = textFormatted;
            return this;
        }

        @Override
        public _FinalStage addAllWords(List<Word> words) {
            this.words.addAll(words);
            return this;
        }

        @Override
        public _FinalStage addWords(Word words) {
            this.words.add(words);
            return this;
        }

        @Override
        @JsonSetter(value="words", nulls=Nulls.SKIP)
        public _FinalStage words(List<Word> words) {
            this.words.clear();
            this.words.addAll(words);
            return this;
        }

        @Override
        public FinalTranscript build() {
            return new FinalTranscript(this.messageType, this.audioStart, this.audioEnd, this.confidence, this.text, this.words, this.created, this.punctuated, this.textFormatted, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public FinalTranscript build();

        public _FinalStage words(List<Word> var1);

        public _FinalStage addWords(Word var1);

        public _FinalStage addAllWords(List<Word> var1);
    }

    public static interface TextFormattedStage {
        public _FinalStage textFormatted(boolean var1);
    }

    public static interface PunctuatedStage {
        public TextFormattedStage punctuated(boolean var1);
    }

    public static interface CreatedStage {
        public PunctuatedStage created(OffsetDateTime var1);
    }

    public static interface TextStage {
        public CreatedStage text(String var1);
    }

    public static interface ConfidenceStage {
        public TextStage confidence(double var1);
    }

    public static interface AudioEndStage {
        public ConfidenceStage audioEnd(int var1);
    }

    public static interface AudioStartStage {
        public AudioEndStage audioStart(int var1);

        public Builder from(FinalTranscript var1);
    }
}

