/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.requests;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.transcripts.types.TranscriptStatus;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ListTranscriptParams {
    private final Optional<Integer> limit;
    private final Optional<TranscriptStatus> status;
    private final Optional<String> createdOn;
    private final Optional<String> beforeId;
    private final Optional<String> afterId;
    private final Optional<Boolean> throttledOnly;
    private final Map<String, Object> additionalProperties;

    private ListTranscriptParams(Optional<Integer> limit, Optional<TranscriptStatus> status, Optional<String> createdOn, Optional<String> beforeId, Optional<String> afterId, Optional<Boolean> throttledOnly, Map<String, Object> additionalProperties) {
        this.limit = limit;
        this.status = status;
        this.createdOn = createdOn;
        this.beforeId = beforeId;
        this.afterId = afterId;
        this.throttledOnly = throttledOnly;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="status")
    public Optional<TranscriptStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="created_on")
    public Optional<String> getCreatedOn() {
        return this.createdOn;
    }

    @JsonProperty(value="before_id")
    public Optional<String> getBeforeId() {
        return this.beforeId;
    }

    @JsonProperty(value="after_id")
    public Optional<String> getAfterId() {
        return this.afterId;
    }

    @JsonProperty(value="throttled_only")
    public Optional<Boolean> getThrottledOnly() {
        return this.throttledOnly;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListTranscriptParams && this.equalTo((ListTranscriptParams)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListTranscriptParams other) {
        return this.limit.equals(other.limit) && this.status.equals(other.status) && this.createdOn.equals(other.createdOn) && this.beforeId.equals(other.beforeId) && this.afterId.equals(other.afterId) && this.throttledOnly.equals(other.throttledOnly);
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.status, this.createdOn, this.beforeId, this.afterId, this.throttledOnly);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> limit = Optional.empty();
        private Optional<TranscriptStatus> status = Optional.empty();
        private Optional<String> createdOn = Optional.empty();
        private Optional<String> beforeId = Optional.empty();
        private Optional<String> afterId = Optional.empty();
        private Optional<Boolean> throttledOnly = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListTranscriptParams other) {
            this.limit(other.getLimit());
            this.status(other.getStatus());
            this.createdOn(other.getCreatedOn());
            this.beforeId(other.getBeforeId());
            this.afterId(other.getAfterId());
            this.throttledOnly(other.getThrottledOnly());
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.of(limit);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<TranscriptStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(TranscriptStatus status) {
            this.status = Optional.of(status);
            return this;
        }

        @JsonSetter(value="created_on", nulls=Nulls.SKIP)
        public Builder createdOn(Optional<String> createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public Builder createdOn(String createdOn) {
            this.createdOn = Optional.of(createdOn);
            return this;
        }

        @JsonSetter(value="before_id", nulls=Nulls.SKIP)
        public Builder beforeId(Optional<String> beforeId) {
            this.beforeId = beforeId;
            return this;
        }

        public Builder beforeId(String beforeId) {
            this.beforeId = Optional.of(beforeId);
            return this;
        }

        @JsonSetter(value="after_id", nulls=Nulls.SKIP)
        public Builder afterId(Optional<String> afterId) {
            this.afterId = afterId;
            return this;
        }

        public Builder afterId(String afterId) {
            this.afterId = Optional.of(afterId);
            return this;
        }

        @JsonSetter(value="throttled_only", nulls=Nulls.SKIP)
        public Builder throttledOnly(Optional<Boolean> throttledOnly) {
            this.throttledOnly = throttledOnly;
            return this;
        }

        public Builder throttledOnly(Boolean throttledOnly) {
            this.throttledOnly = Optional.of(throttledOnly);
            return this;
        }

        public ListTranscriptParams build() {
            return new ListTranscriptParams(this.limit, this.status, this.createdOn, this.beforeId, this.afterId, this.throttledOnly, this.additionalProperties);
        }
    }
}

