/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.requests;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class WordSearchParams {
    private final Optional<String> words;
    private final Map<String, Object> additionalProperties;

    private WordSearchParams(Optional<String> words, Map<String, Object> additionalProperties) {
        this.words = words;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="words")
    public Optional<String> getWords() {
        return this.words;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof WordSearchParams && this.equalTo((WordSearchParams)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(WordSearchParams other) {
        return this.words.equals(other.words);
    }

    public int hashCode() {
        return Objects.hash(this.words);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> words = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(WordSearchParams other) {
            this.words(other.getWords());
            return this;
        }

        @JsonSetter(value="words", nulls=Nulls.SKIP)
        public Builder words(Optional<String> words) {
            this.words = words;
            return this;
        }

        public Builder words(String words) {
            this.words = Optional.of(words);
            return this;
        }

        public WordSearchParams build() {
            return new WordSearchParams(this.words, this.additionalProperties);
        }
    }
}

