/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.transcripts.types.EntityType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Entity {
    private final EntityType entityType;
    private final String text;
    private final int start;
    private final int end;
    private final Map<String, Object> additionalProperties;

    private Entity(EntityType entityType, String text, int start, int end, Map<String, Object> additionalProperties) {
        this.entityType = entityType;
        this.text = text;
        this.start = start;
        this.end = end;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="entity_type")
    public EntityType getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="start")
    public int getStart() {
        return this.start;
    }

    @JsonProperty(value="end")
    public int getEnd() {
        return this.end;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Entity && this.equalTo((Entity)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Entity other) {
        return this.entityType.equals(other.entityType) && this.text.equals(other.text) && this.start == other.start && this.end == other.end;
    }

    public int hashCode() {
        return Objects.hash(this.entityType, this.text, this.start, this.end);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EntityTypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements EntityTypeStage,
    TextStage,
    StartStage,
    EndStage,
    _FinalStage {
        private EntityType entityType;
        private String text;
        private int start;
        private int end;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Entity other) {
            this.entityType(other.getEntityType());
            this.text(other.getText());
            this.start(other.getStart());
            this.end(other.getEnd());
            return this;
        }

        @Override
        @JsonSetter(value="entity_type")
        public TextStage entityType(EntityType entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        @JsonSetter(value="text")
        public StartStage text(String text) {
            this.text = text;
            return this;
        }

        @Override
        @JsonSetter(value="start")
        public EndStage start(int start) {
            this.start = start;
            return this;
        }

        @Override
        @JsonSetter(value="end")
        public _FinalStage end(int end) {
            this.end = end;
            return this;
        }

        @Override
        public Entity build() {
            return new Entity(this.entityType, this.text, this.start, this.end, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Entity build();
    }

    public static interface EndStage {
        public _FinalStage end(int var1);
    }

    public static interface StartStage {
        public EndStage start(int var1);
    }

    public static interface TextStage {
        public StartStage text(String var1);
    }

    public static interface EntityTypeStage {
        public TextStage entityType(EntityType var1);

        public Builder from(Entity var1);
    }
}

