/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.transcripts.types.TranscriptParagraph;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ParagraphsResponse {
    private final String id;
    private final double confidence;
    private final double audioDuration;
    private final List<TranscriptParagraph> paragraphs;
    private final Map<String, Object> additionalProperties;

    private ParagraphsResponse(String id, double confidence, double audioDuration, List<TranscriptParagraph> paragraphs, Map<String, Object> additionalProperties) {
        this.id = id;
        this.confidence = confidence;
        this.audioDuration = audioDuration;
        this.paragraphs = paragraphs;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="confidence")
    public double getConfidence() {
        return this.confidence;
    }

    @JsonProperty(value="audio_duration")
    public double getAudioDuration() {
        return this.audioDuration;
    }

    @JsonProperty(value="paragraphs")
    public List<TranscriptParagraph> getParagraphs() {
        return this.paragraphs;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ParagraphsResponse && this.equalTo((ParagraphsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ParagraphsResponse other) {
        return this.id.equals(other.id) && this.confidence == other.confidence && this.audioDuration == other.audioDuration && this.paragraphs.equals(other.paragraphs);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.confidence, this.audioDuration, this.paragraphs);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    ConfidenceStage,
    AudioDurationStage,
    _FinalStage {
        private String id;
        private double confidence;
        private double audioDuration;
        private List<TranscriptParagraph> paragraphs = new ArrayList<TranscriptParagraph>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ParagraphsResponse other) {
            this.id(other.getId());
            this.confidence(other.getConfidence());
            this.audioDuration(other.getAudioDuration());
            this.paragraphs(other.getParagraphs());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public ConfidenceStage id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @JsonSetter(value="confidence")
        public AudioDurationStage confidence(double confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        @JsonSetter(value="audio_duration")
        public _FinalStage audioDuration(double audioDuration) {
            this.audioDuration = audioDuration;
            return this;
        }

        @Override
        public _FinalStage addAllParagraphs(List<TranscriptParagraph> paragraphs) {
            this.paragraphs.addAll(paragraphs);
            return this;
        }

        @Override
        public _FinalStage addParagraphs(TranscriptParagraph paragraphs) {
            this.paragraphs.add(paragraphs);
            return this;
        }

        @Override
        @JsonSetter(value="paragraphs", nulls=Nulls.SKIP)
        public _FinalStage paragraphs(List<TranscriptParagraph> paragraphs) {
            this.paragraphs.clear();
            this.paragraphs.addAll(paragraphs);
            return this;
        }

        @Override
        public ParagraphsResponse build() {
            return new ParagraphsResponse(this.id, this.confidence, this.audioDuration, this.paragraphs, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ParagraphsResponse build();

        public _FinalStage paragraphs(List<TranscriptParagraph> var1);

        public _FinalStage addParagraphs(TranscriptParagraph var1);

        public _FinalStage addAllParagraphs(List<TranscriptParagraph> var1);
    }

    public static interface AudioDurationStage {
        public _FinalStage audioDuration(double var1);
    }

    public static interface ConfidenceStage {
        public AudioDurationStage confidence(double var1);
    }

    public static interface IdStage {
        public ConfidenceStage id(String var1);

        public Builder from(ParagraphsResponse var1);
    }
}

