/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class SummaryModel {
    public static final SummaryModel CATCHY = new SummaryModel(Value.CATCHY, "catchy");
    public static final SummaryModel CONVERSATIONAL = new SummaryModel(Value.CONVERSATIONAL, "conversational");
    public static final SummaryModel INFORMATIVE = new SummaryModel(Value.INFORMATIVE, "informative");
    private final Value value;
    private final String string;

    SummaryModel(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof SummaryModel && this.string.equals(((SummaryModel)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case CATCHY: {
                return visitor.visitCatchy();
            }
            case CONVERSATIONAL: {
                return visitor.visitConversational();
            }
            case INFORMATIVE: {
                return visitor.visitInformative();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static SummaryModel valueOf(String value) {
        switch (value) {
            case "catchy": {
                return CATCHY;
            }
            case "conversational": {
                return CONVERSATIONAL;
            }
            case "informative": {
                return INFORMATIVE;
            }
        }
        return new SummaryModel(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitInformative();

        public T visitConversational();

        public T visitCatchy();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        INFORMATIVE,
        CONVERSATIONAL,
        CATCHY,
        UNKNOWN;

    }
}

