/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.transcripts.types.Timestamp;
import com.assemblyai.api.resources.transcripts.types.TopicDetectionResultLabelsItem;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class TopicDetectionResult {
    private final String text;
    private final Optional<List<TopicDetectionResultLabelsItem>> labels;
    private final Optional<Timestamp> timestamp;
    private final Map<String, Object> additionalProperties;

    private TopicDetectionResult(String text, Optional<List<TopicDetectionResultLabelsItem>> labels, Optional<Timestamp> timestamp, Map<String, Object> additionalProperties) {
        this.text = text;
        this.labels = labels;
        this.timestamp = timestamp;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="labels")
    public Optional<List<TopicDetectionResultLabelsItem>> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="timestamp")
    public Optional<Timestamp> getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TopicDetectionResult && this.equalTo((TopicDetectionResult)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TopicDetectionResult other) {
        return this.text.equals(other.text) && this.labels.equals(other.labels) && this.timestamp.equals(other.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.labels, this.timestamp);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TextStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TextStage,
    _FinalStage {
        private String text;
        private Optional<Timestamp> timestamp = Optional.empty();
        private Optional<List<TopicDetectionResultLabelsItem>> labels = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TopicDetectionResult other) {
            this.text(other.getText());
            this.labels(other.getLabels());
            this.timestamp(other.getTimestamp());
            return this;
        }

        @Override
        @JsonSetter(value="text")
        public _FinalStage text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public _FinalStage timestamp(Timestamp timestamp) {
            this.timestamp = Optional.of(timestamp);
            return this;
        }

        @Override
        @JsonSetter(value="timestamp", nulls=Nulls.SKIP)
        public _FinalStage timestamp(Optional<Timestamp> timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public _FinalStage labels(List<TopicDetectionResultLabelsItem> labels) {
            this.labels = Optional.of(labels);
            return this;
        }

        @Override
        @JsonSetter(value="labels", nulls=Nulls.SKIP)
        public _FinalStage labels(Optional<List<TopicDetectionResultLabelsItem>> labels) {
            this.labels = labels;
            return this;
        }

        @Override
        public TopicDetectionResult build() {
            return new TopicDetectionResult(this.text, this.labels, this.timestamp, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TopicDetectionResult build();

        public _FinalStage labels(Optional<List<TopicDetectionResultLabelsItem>> var1);

        public _FinalStage labels(List<TopicDetectionResultLabelsItem> var1);

        public _FinalStage timestamp(Optional<Timestamp> var1);

        public _FinalStage timestamp(Timestamp var1);
    }

    public static interface TextStage {
        public _FinalStage text(String var1);

        public Builder from(TopicDetectionResult var1);
    }
}

