/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class TranscriptBoostParam {
    public static final TranscriptBoostParam LOW = new TranscriptBoostParam(Value.LOW, "low");
    public static final TranscriptBoostParam DEFAULT = new TranscriptBoostParam(Value.DEFAULT, "default");
    public static final TranscriptBoostParam HIGH = new TranscriptBoostParam(Value.HIGH, "high");
    private final Value value;
    private final String string;

    TranscriptBoostParam(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof TranscriptBoostParam && this.string.equals(((TranscriptBoostParam)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case LOW: {
                return visitor.visitLow();
            }
            case DEFAULT: {
                return visitor.visitDefault();
            }
            case HIGH: {
                return visitor.visitHigh();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static TranscriptBoostParam valueOf(String value) {
        switch (value) {
            case "low": {
                return LOW;
            }
            case "default": {
                return DEFAULT;
            }
            case "high": {
                return HIGH;
            }
        }
        return new TranscriptBoostParam(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitLow();

        public T visitDefault();

        public T visitHigh();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        LOW,
        DEFAULT,
        HIGH,
        UNKNOWN;

    }
}

