/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api;

import com.assemblyai.api.AssemblyAI;
import com.assemblyai.api.core.ClientOptions;
import com.assemblyai.api.core.Environment;
import com.assemblyai.api.core.UserAgent;

public final class AssemblyAIBuilder {
    private ClientOptions.Builder clientOptionsBuilder = ClientOptions.builder();
    private ClientOptions.Builder lemurClientOptionsBuilder = ClientOptions.builder();
    private String apiKey = null;
    private UserAgent userAgent = UserAgent.getDefault();
    private Environment environment = Environment.DEFAULT;

    public AssemblyAIBuilder apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public AssemblyAIBuilder environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public AssemblyAIBuilder userAgent(UserAgent userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public AssemblyAIBuilder url(String url) {
        this.environment = Environment.custom(url);
        return this;
    }

    public AssemblyAI build() {
        if (this.apiKey == null) {
            throw new RuntimeException("Please provide apiKey");
        }
        this.clientOptionsBuilder.addHeader("Authorization", this.apiKey);
        this.clientOptionsBuilder.environment(this.environment).userAgent(this.userAgent);
        this.lemurClientOptionsBuilder.addHeader("Authorization", this.apiKey);
        this.lemurClientOptionsBuilder.environment(this.environment).userAgent(this.userAgent).disableTimeouts();
        return new AssemblyAI(this.clientOptionsBuilder.build(), this.lemurClientOptionsBuilder.build());
    }
}

