/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api;

import com.assemblyai.api.AssemblyAI;
import com.assemblyai.api.core.ClientOptions;
import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.core.RequestOptions;
import com.assemblyai.api.resources.files.types.UploadedFile;
import com.assemblyai.api.resources.transcripts.TranscriptsClient;
import com.assemblyai.api.resources.transcripts.requests.TranscriptParams;
import com.assemblyai.api.resources.transcripts.requests.WordSearchParams;
import com.assemblyai.api.resources.transcripts.types.Transcript;
import com.assemblyai.api.resources.transcripts.types.TranscriptOptionalParams;
import com.assemblyai.api.resources.transcripts.types.TranscriptStatus;
import com.assemblyai.api.resources.transcripts.types.WordSearchResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;

public class PollingTranscriptsClient
extends TranscriptsClient {
    private static final TranscriptOptionalParams EMPTY_PARAMS = TranscriptOptionalParams.builder().build();
    private final AssemblyAI client;

    public PollingTranscriptsClient(ClientOptions clientOptions, AssemblyAI client) {
        super(clientOptions);
        this.client = client;
    }

    public Transcript submit(File file) throws IOException {
        return this.submit(file.toPath(), EMPTY_PARAMS, null);
    }

    public Transcript submit(File file, RequestOptions requestOptions) throws IOException {
        return this.submit(file.toPath(), EMPTY_PARAMS, requestOptions);
    }

    public Transcript submit(File file, TranscriptOptionalParams transcriptParams) throws IOException {
        return this.submit(file.toPath(), transcriptParams, null);
    }

    public Transcript submit(File file, TranscriptOptionalParams transcriptParams, RequestOptions requestOptions) throws IOException {
        return this.submit(file.toPath(), transcriptParams, requestOptions);
    }

    public Transcript submit(Path filePath) throws IOException {
        return this.submit(filePath, EMPTY_PARAMS, null);
    }

    public Transcript submit(Path filePath, RequestOptions requestOptions) throws IOException {
        return this.submit(filePath, EMPTY_PARAMS, requestOptions);
    }

    public Transcript submit(Path filePath, TranscriptOptionalParams transcriptParams) throws IOException {
        UploadedFile uploadedFile = this.client.files().upload(filePath);
        return this.submit(uploadedFile.getUploadUrl(), transcriptParams, null);
    }

    public Transcript submit(Path filePath, TranscriptOptionalParams transcriptParams, RequestOptions requestOptions) throws IOException {
        UploadedFile uploadedFile = this.client.files().upload(filePath, requestOptions);
        return this.submit(uploadedFile.getUploadUrl(), transcriptParams, requestOptions);
    }

    public Transcript submit(UploadedFile file) {
        return this.submit(file.getUploadUrl(), EMPTY_PARAMS, null);
    }

    public Transcript submit(UploadedFile file, RequestOptions requestOptions) {
        return this.submit(file.getUploadUrl(), EMPTY_PARAMS, requestOptions);
    }

    public Transcript submit(UploadedFile file, TranscriptOptionalParams transcriptParams) {
        return this.submit(file.getUploadUrl(), transcriptParams, null);
    }

    public Transcript submit(UploadedFile file, TranscriptOptionalParams transcriptParams, RequestOptions requestOptions) {
        return this.submit(file.getUploadUrl(), transcriptParams, requestOptions);
    }

    public Transcript submit(String url) {
        return this.submit(url, EMPTY_PARAMS, null);
    }

    public Transcript submit(String url, RequestOptions requestOptions) {
        return this.submit(url, EMPTY_PARAMS, requestOptions);
    }

    public Transcript submit(String url, TranscriptOptionalParams transcriptParams) {
        return this.submit(url, transcriptParams, null);
    }

    public Transcript submit(String url, TranscriptOptionalParams transcriptParams, RequestOptions requestOptions) {
        TranscriptParams fullTranscriptParams;
        ObjectNode transcriptParamsJson = (ObjectNode)ObjectMappers.JSON_MAPPER.valueToTree((Object)transcriptParams);
        transcriptParamsJson.put("audio_url", url);
        try {
            fullTranscriptParams = (TranscriptParams)ObjectMappers.JSON_MAPPER.treeToValue((TreeNode)transcriptParamsJson, TranscriptParams.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return super.submit(fullTranscriptParams, requestOptions);
    }

    public Transcript transcribe(Path filePath) throws IOException {
        return this.transcribe(filePath, EMPTY_PARAMS, null);
    }

    public Transcript transcribe(Path filePath, RequestOptions requestOptions) throws IOException {
        return this.transcribe(filePath, EMPTY_PARAMS, requestOptions);
    }

    public Transcript transcribe(Path filePath, TranscriptOptionalParams transcriptParams) throws IOException {
        UploadedFile uploadedFile = this.client.files().upload(filePath);
        return this.transcribe(uploadedFile.getUploadUrl(), transcriptParams, null);
    }

    public Transcript transcribe(Path filePath, TranscriptOptionalParams transcriptParams, RequestOptions requestOptions) throws IOException {
        UploadedFile uploadedFile = this.client.files().upload(filePath, requestOptions);
        return this.transcribe(uploadedFile.getUploadUrl(), transcriptParams, requestOptions);
    }

    public Transcript transcribe(File file) throws IOException {
        return this.transcribe(file, EMPTY_PARAMS, null);
    }

    public Transcript transcribe(File file, RequestOptions requestOptions) throws IOException {
        return this.transcribe(file, EMPTY_PARAMS, requestOptions);
    }

    public Transcript transcribe(File file, TranscriptOptionalParams transcriptParams) throws IOException {
        return this.transcribe(file, transcriptParams, null);
    }

    public Transcript transcribe(File file, TranscriptOptionalParams transcriptParams, RequestOptions requestOptions) throws IOException {
        UploadedFile uploadedFile = this.client.files().upload(Files.readAllBytes(file.toPath()), requestOptions);
        return this.transcribe(uploadedFile.getUploadUrl(), transcriptParams, requestOptions);
    }

    public Transcript transcribe(UploadedFile file) {
        return this.transcribe(file, EMPTY_PARAMS, null);
    }

    public Transcript transcribe(UploadedFile file, RequestOptions requestOptions) {
        return this.transcribe(file, EMPTY_PARAMS, requestOptions);
    }

    public Transcript transcribe(UploadedFile file, TranscriptOptionalParams transcriptParams) {
        return this.transcribe(file.getUploadUrl(), transcriptParams, null);
    }

    public Transcript transcribe(UploadedFile file, TranscriptOptionalParams transcriptParams, RequestOptions requestOptions) {
        return this.transcribe(file.getUploadUrl(), transcriptParams, requestOptions);
    }

    public Transcript transcribe(String url) {
        return this.transcribe(url, EMPTY_PARAMS, null);
    }

    public Transcript transcribe(String url, RequestOptions requestOptions) {
        return this.transcribe(url, EMPTY_PARAMS, requestOptions);
    }

    public Transcript transcribe(String url, TranscriptOptionalParams transcriptParams) {
        return this.transcribe(url, transcriptParams, null);
    }

    public Transcript transcribe(String url, TranscriptOptionalParams transcriptParams, RequestOptions requestOptions) {
        Transcript transcriptResponse = this.submit(url, transcriptParams, requestOptions);
        return this.waitUntilReady(transcriptResponse.getId(), requestOptions);
    }

    public Transcript transcribe(TranscriptParams transcriptParams) {
        Transcript transcriptResponse = this.submit(transcriptParams, null);
        return this.waitUntilReady(transcriptResponse.getId());
    }

    public Transcript waitUntilReady(String transcriptId) {
        return this.waitUntilReady(transcriptId, null);
    }

    public Transcript waitUntilReady(String transcriptId, RequestOptions requestOptions) {
        try {
            while (true) {
                Transcript transcript;
                TranscriptStatus status;
                if ((status = (transcript = this.client.transcripts().get(transcriptId, requestOptions)).getStatus()).equals(TranscriptStatus.COMPLETED) || status.equals(TranscriptStatus.ERROR)) {
                    return transcript;
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while polling transcript id=" + transcriptId);
        }
    }

    public WordSearchResponse wordSearch(String transcriptId, List<String> words) {
        return this.wordSearch(transcriptId, words, null);
    }

    public WordSearchResponse wordSearch(String transcriptId, List<String> words, RequestOptions requestOptions) {
        return this.wordSearch(transcriptId, WordSearchParams.builder().words(String.join((CharSequence)",", words)).build(), requestOptions);
    }
}

