/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.lemur;

import com.assemblyai.api.core.AssemblyAIApiException;
import com.assemblyai.api.core.AssemblyAIException;
import com.assemblyai.api.core.ClientOptions;
import com.assemblyai.api.core.MediaTypes;
import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.core.RequestOptions;
import com.assemblyai.api.errors.BadRequestError;
import com.assemblyai.api.errors.GatewayTimeoutError;
import com.assemblyai.api.errors.InternalServerError;
import com.assemblyai.api.errors.NotFoundError;
import com.assemblyai.api.errors.ServiceUnavailableError;
import com.assemblyai.api.errors.TooManyRequestsError;
import com.assemblyai.api.errors.UnauthorizedError;
import com.assemblyai.api.resources.lemur.requests.LemurActionItemsParams;
import com.assemblyai.api.resources.lemur.requests.LemurQuestionAnswerParams;
import com.assemblyai.api.resources.lemur.requests.LemurSummaryParams;
import com.assemblyai.api.resources.lemur.requests.LemurTaskParams;
import com.assemblyai.api.resources.lemur.types.LemurActionItemsResponse;
import com.assemblyai.api.resources.lemur.types.LemurQuestionAnswerResponse;
import com.assemblyai.api.resources.lemur.types.LemurResponse;
import com.assemblyai.api.resources.lemur.types.LemurSummaryResponse;
import com.assemblyai.api.resources.lemur.types.LemurTaskResponse;
import com.assemblyai.api.resources.lemur.types.PurgeLemurRequestDataResponse;
import com.assemblyai.api.types.Error;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class LemurClient {
    protected final ClientOptions clientOptions;

    public LemurClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public LemurTaskResponse task(LemurTaskParams request) {
        return this.task(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LemurTaskResponse task(LemurTaskParams request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("lemur/v3/generate/task").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new AssemblyAIException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                LemurTaskResponse lemurTaskResponse = (LemurTaskResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), LemurTaskResponse.class);
                return lemurTaskResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 404: {
                        throw new NotFoundError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 429: {
                        throw new TooManyRequestsError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 500: {
                        throw new InternalServerError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 503: {
                        throw new ServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new GatewayTimeoutError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new AssemblyAIException("Network error executing HTTP request", e);
        }
    }

    public LemurSummaryResponse summary() {
        return this.summary(LemurSummaryParams.builder().build());
    }

    public LemurSummaryResponse summary(LemurSummaryParams request) {
        return this.summary(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LemurSummaryResponse summary(LemurSummaryParams request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("lemur/v3/generate/summary").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new AssemblyAIException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                LemurSummaryResponse lemurSummaryResponse = (LemurSummaryResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), LemurSummaryResponse.class);
                return lemurSummaryResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 404: {
                        throw new NotFoundError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 429: {
                        throw new TooManyRequestsError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 500: {
                        throw new InternalServerError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 503: {
                        throw new ServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new GatewayTimeoutError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new AssemblyAIException("Network error executing HTTP request", e);
        }
    }

    public LemurQuestionAnswerResponse questionAnswer(LemurQuestionAnswerParams request) {
        return this.questionAnswer(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LemurQuestionAnswerResponse questionAnswer(LemurQuestionAnswerParams request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("lemur/v3/generate/question-answer").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new AssemblyAIException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                LemurQuestionAnswerResponse lemurQuestionAnswerResponse = (LemurQuestionAnswerResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), LemurQuestionAnswerResponse.class);
                return lemurQuestionAnswerResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 404: {
                        throw new NotFoundError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 429: {
                        throw new TooManyRequestsError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 500: {
                        throw new InternalServerError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 503: {
                        throw new ServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new GatewayTimeoutError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new AssemblyAIException("Network error executing HTTP request", e);
        }
    }

    public LemurActionItemsResponse actionItems() {
        return this.actionItems(LemurActionItemsParams.builder().build());
    }

    public LemurActionItemsResponse actionItems(LemurActionItemsParams request) {
        return this.actionItems(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LemurActionItemsResponse actionItems(LemurActionItemsParams request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("lemur/v3/generate/action-items").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new AssemblyAIException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                LemurActionItemsResponse lemurActionItemsResponse = (LemurActionItemsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), LemurActionItemsResponse.class);
                return lemurActionItemsResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 404: {
                        throw new NotFoundError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 429: {
                        throw new TooManyRequestsError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 500: {
                        throw new InternalServerError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 503: {
                        throw new ServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new GatewayTimeoutError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new AssemblyAIException("Network error executing HTTP request", e);
        }
    }

    public LemurResponse getResponse(String requestId) {
        return this.getResponse(requestId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LemurResponse getResponse(String requestId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("lemur/v3").addPathSegment(requestId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                LemurResponse lemurResponse = (LemurResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), LemurResponse.class);
                return lemurResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 404: {
                        throw new NotFoundError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 429: {
                        throw new TooManyRequestsError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 500: {
                        throw new InternalServerError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 503: {
                        throw new ServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new GatewayTimeoutError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new AssemblyAIException("Network error executing HTTP request", e);
        }
    }

    public PurgeLemurRequestDataResponse purgeRequestData(String requestId) {
        return this.purgeRequestData(requestId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PurgeLemurRequestDataResponse purgeRequestData(String requestId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("lemur/v3").addPathSegment(requestId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                PurgeLemurRequestDataResponse purgeLemurRequestDataResponse = (PurgeLemurRequestDataResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), PurgeLemurRequestDataResponse.class);
                return purgeLemurRequestDataResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 404: {
                        throw new NotFoundError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 429: {
                        throw new TooManyRequestsError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 500: {
                        throw new InternalServerError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 503: {
                        throw new ServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new GatewayTimeoutError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new AssemblyAIException("Network error executing HTTP request", e);
        }
    }
}

