/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.lemur.requests;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.lemur.types.ILemurBaseParams;
import com.assemblyai.api.resources.lemur.types.LemurBaseParamsContext;
import com.assemblyai.api.resources.lemur.types.LemurModel;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LemurActionItemsParams
implements ILemurBaseParams {
    private final Optional<List<String>> transcriptIds;
    private final Optional<String> inputText;
    private final Optional<LemurBaseParamsContext> context;
    private final Optional<LemurModel> finalModel;
    private final Optional<Integer> maxOutputSize;
    private final Optional<Double> temperature;
    private final Optional<String> answerFormat;
    private final Map<String, Object> additionalProperties;

    private LemurActionItemsParams(Optional<List<String>> transcriptIds, Optional<String> inputText, Optional<LemurBaseParamsContext> context, Optional<LemurModel> finalModel, Optional<Integer> maxOutputSize, Optional<Double> temperature, Optional<String> answerFormat, Map<String, Object> additionalProperties) {
        this.transcriptIds = transcriptIds;
        this.inputText = inputText;
        this.context = context;
        this.finalModel = finalModel;
        this.maxOutputSize = maxOutputSize;
        this.temperature = temperature;
        this.answerFormat = answerFormat;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="transcript_ids")
    public Optional<List<String>> getTranscriptIds() {
        return this.transcriptIds;
    }

    @Override
    @JsonProperty(value="input_text")
    public Optional<String> getInputText() {
        return this.inputText;
    }

    @Override
    @JsonProperty(value="context")
    public Optional<LemurBaseParamsContext> getContext() {
        return this.context;
    }

    @Override
    @JsonProperty(value="final_model")
    public Optional<LemurModel> getFinalModel() {
        return this.finalModel;
    }

    @Override
    @JsonProperty(value="max_output_size")
    public Optional<Integer> getMaxOutputSize() {
        return this.maxOutputSize;
    }

    @Override
    @JsonProperty(value="temperature")
    public Optional<Double> getTemperature() {
        return this.temperature;
    }

    @JsonProperty(value="answer_format")
    public Optional<String> getAnswerFormat() {
        return this.answerFormat;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LemurActionItemsParams && this.equalTo((LemurActionItemsParams)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LemurActionItemsParams other) {
        return this.transcriptIds.equals(other.transcriptIds) && this.inputText.equals(other.inputText) && this.context.equals(other.context) && this.finalModel.equals(other.finalModel) && this.maxOutputSize.equals(other.maxOutputSize) && this.temperature.equals(other.temperature) && this.answerFormat.equals(other.answerFormat);
    }

    public int hashCode() {
        return Objects.hash(this.transcriptIds, this.inputText, this.context, this.finalModel, this.maxOutputSize, this.temperature, this.answerFormat);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<String>> transcriptIds = Optional.empty();
        private Optional<String> inputText = Optional.empty();
        private Optional<LemurBaseParamsContext> context = Optional.empty();
        private Optional<LemurModel> finalModel = Optional.empty();
        private Optional<Integer> maxOutputSize = Optional.empty();
        private Optional<Double> temperature = Optional.empty();
        private Optional<String> answerFormat = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(LemurActionItemsParams other) {
            this.transcriptIds(other.getTranscriptIds());
            this.inputText(other.getInputText());
            this.context(other.getContext());
            this.finalModel(other.getFinalModel());
            this.maxOutputSize(other.getMaxOutputSize());
            this.temperature(other.getTemperature());
            this.answerFormat(other.getAnswerFormat());
            return this;
        }

        @JsonSetter(value="transcript_ids", nulls=Nulls.SKIP)
        public Builder transcriptIds(Optional<List<String>> transcriptIds) {
            this.transcriptIds = transcriptIds;
            return this;
        }

        public Builder transcriptIds(List<String> transcriptIds) {
            this.transcriptIds = Optional.ofNullable(transcriptIds);
            return this;
        }

        @JsonSetter(value="input_text", nulls=Nulls.SKIP)
        public Builder inputText(Optional<String> inputText) {
            this.inputText = inputText;
            return this;
        }

        public Builder inputText(String inputText) {
            this.inputText = Optional.ofNullable(inputText);
            return this;
        }

        @JsonSetter(value="context", nulls=Nulls.SKIP)
        public Builder context(Optional<LemurBaseParamsContext> context) {
            this.context = context;
            return this;
        }

        public Builder context(LemurBaseParamsContext context) {
            this.context = Optional.ofNullable(context);
            return this;
        }

        @JsonSetter(value="final_model", nulls=Nulls.SKIP)
        public Builder finalModel(Optional<LemurModel> finalModel) {
            this.finalModel = finalModel;
            return this;
        }

        public Builder finalModel(LemurModel finalModel) {
            this.finalModel = Optional.ofNullable(finalModel);
            return this;
        }

        @JsonSetter(value="max_output_size", nulls=Nulls.SKIP)
        public Builder maxOutputSize(Optional<Integer> maxOutputSize) {
            this.maxOutputSize = maxOutputSize;
            return this;
        }

        public Builder maxOutputSize(Integer maxOutputSize) {
            this.maxOutputSize = Optional.ofNullable(maxOutputSize);
            return this;
        }

        @JsonSetter(value="temperature", nulls=Nulls.SKIP)
        public Builder temperature(Optional<Double> temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = Optional.ofNullable(temperature);
            return this;
        }

        @JsonSetter(value="answer_format", nulls=Nulls.SKIP)
        public Builder answerFormat(Optional<String> answerFormat) {
            this.answerFormat = answerFormat;
            return this;
        }

        public Builder answerFormat(String answerFormat) {
            this.answerFormat = Optional.ofNullable(answerFormat);
            return this;
        }

        public LemurActionItemsParams build() {
            return new LemurActionItemsParams(this.transcriptIds, this.inputText, this.context, this.finalModel, this.maxOutputSize, this.temperature, this.answerFormat, this.additionalProperties);
        }
    }
}

