/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.lemur.requests;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.lemur.types.ILemurBaseParams;
import com.assemblyai.api.resources.lemur.types.LemurBaseParamsContext;
import com.assemblyai.api.resources.lemur.types.LemurModel;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LemurTaskParams
implements ILemurBaseParams {
    private final Optional<List<String>> transcriptIds;
    private final Optional<String> inputText;
    private final Optional<LemurBaseParamsContext> context;
    private final Optional<LemurModel> finalModel;
    private final Optional<Integer> maxOutputSize;
    private final Optional<Double> temperature;
    private final String prompt;
    private final Map<String, Object> additionalProperties;

    private LemurTaskParams(Optional<List<String>> transcriptIds, Optional<String> inputText, Optional<LemurBaseParamsContext> context, Optional<LemurModel> finalModel, Optional<Integer> maxOutputSize, Optional<Double> temperature, String prompt, Map<String, Object> additionalProperties) {
        this.transcriptIds = transcriptIds;
        this.inputText = inputText;
        this.context = context;
        this.finalModel = finalModel;
        this.maxOutputSize = maxOutputSize;
        this.temperature = temperature;
        this.prompt = prompt;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="transcript_ids")
    public Optional<List<String>> getTranscriptIds() {
        return this.transcriptIds;
    }

    @Override
    @JsonProperty(value="input_text")
    public Optional<String> getInputText() {
        return this.inputText;
    }

    @Override
    @JsonProperty(value="context")
    public Optional<LemurBaseParamsContext> getContext() {
        return this.context;
    }

    @Override
    @JsonProperty(value="final_model")
    public Optional<LemurModel> getFinalModel() {
        return this.finalModel;
    }

    @Override
    @JsonProperty(value="max_output_size")
    public Optional<Integer> getMaxOutputSize() {
        return this.maxOutputSize;
    }

    @Override
    @JsonProperty(value="temperature")
    public Optional<Double> getTemperature() {
        return this.temperature;
    }

    @JsonProperty(value="prompt")
    public String getPrompt() {
        return this.prompt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LemurTaskParams && this.equalTo((LemurTaskParams)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LemurTaskParams other) {
        return this.transcriptIds.equals(other.transcriptIds) && this.inputText.equals(other.inputText) && this.context.equals(other.context) && this.finalModel.equals(other.finalModel) && this.maxOutputSize.equals(other.maxOutputSize) && this.temperature.equals(other.temperature) && this.prompt.equals(other.prompt);
    }

    public int hashCode() {
        return Objects.hash(this.transcriptIds, this.inputText, this.context, this.finalModel, this.maxOutputSize, this.temperature, this.prompt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PromptStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PromptStage,
    _FinalStage {
        private String prompt;
        private Optional<Double> temperature = Optional.empty();
        private Optional<Integer> maxOutputSize = Optional.empty();
        private Optional<LemurModel> finalModel = Optional.empty();
        private Optional<LemurBaseParamsContext> context = Optional.empty();
        private Optional<String> inputText = Optional.empty();
        private Optional<List<String>> transcriptIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LemurTaskParams other) {
            this.transcriptIds(other.getTranscriptIds());
            this.inputText(other.getInputText());
            this.context(other.getContext());
            this.finalModel(other.getFinalModel());
            this.maxOutputSize(other.getMaxOutputSize());
            this.temperature(other.getTemperature());
            this.prompt(other.getPrompt());
            return this;
        }

        @Override
        @JsonSetter(value="prompt")
        public _FinalStage prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        @Override
        public _FinalStage temperature(Double temperature) {
            this.temperature = Optional.ofNullable(temperature);
            return this;
        }

        @Override
        @JsonSetter(value="temperature", nulls=Nulls.SKIP)
        public _FinalStage temperature(Optional<Double> temperature) {
            this.temperature = temperature;
            return this;
        }

        @Override
        public _FinalStage maxOutputSize(Integer maxOutputSize) {
            this.maxOutputSize = Optional.ofNullable(maxOutputSize);
            return this;
        }

        @Override
        @JsonSetter(value="max_output_size", nulls=Nulls.SKIP)
        public _FinalStage maxOutputSize(Optional<Integer> maxOutputSize) {
            this.maxOutputSize = maxOutputSize;
            return this;
        }

        @Override
        public _FinalStage finalModel(LemurModel finalModel) {
            this.finalModel = Optional.ofNullable(finalModel);
            return this;
        }

        @Override
        @JsonSetter(value="final_model", nulls=Nulls.SKIP)
        public _FinalStage finalModel(Optional<LemurModel> finalModel) {
            this.finalModel = finalModel;
            return this;
        }

        @Override
        public _FinalStage context(LemurBaseParamsContext context) {
            this.context = Optional.ofNullable(context);
            return this;
        }

        @Override
        @JsonSetter(value="context", nulls=Nulls.SKIP)
        public _FinalStage context(Optional<LemurBaseParamsContext> context) {
            this.context = context;
            return this;
        }

        @Override
        public _FinalStage inputText(String inputText) {
            this.inputText = Optional.ofNullable(inputText);
            return this;
        }

        @Override
        @JsonSetter(value="input_text", nulls=Nulls.SKIP)
        public _FinalStage inputText(Optional<String> inputText) {
            this.inputText = inputText;
            return this;
        }

        @Override
        public _FinalStage transcriptIds(List<String> transcriptIds) {
            this.transcriptIds = Optional.ofNullable(transcriptIds);
            return this;
        }

        @Override
        @JsonSetter(value="transcript_ids", nulls=Nulls.SKIP)
        public _FinalStage transcriptIds(Optional<List<String>> transcriptIds) {
            this.transcriptIds = transcriptIds;
            return this;
        }

        @Override
        public LemurTaskParams build() {
            return new LemurTaskParams(this.transcriptIds, this.inputText, this.context, this.finalModel, this.maxOutputSize, this.temperature, this.prompt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LemurTaskParams build();

        public _FinalStage transcriptIds(Optional<List<String>> var1);

        public _FinalStage transcriptIds(List<String> var1);

        public _FinalStage inputText(Optional<String> var1);

        public _FinalStage inputText(String var1);

        public _FinalStage context(Optional<LemurBaseParamsContext> var1);

        public _FinalStage context(LemurBaseParamsContext var1);

        public _FinalStage finalModel(Optional<LemurModel> var1);

        public _FinalStage finalModel(LemurModel var1);

        public _FinalStage maxOutputSize(Optional<Integer> var1);

        public _FinalStage maxOutputSize(Integer var1);

        public _FinalStage temperature(Optional<Double> var1);

        public _FinalStage temperature(Double var1);
    }

    public static interface PromptStage {
        public _FinalStage prompt(String var1);

        public Builder from(LemurTaskParams var1);
    }
}

