/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.lemur.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.lemur.types.LemurQuestionContext;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LemurQuestion {
    private final String question;
    private final Optional<LemurQuestionContext> context;
    private final Optional<String> answerFormat;
    private final Optional<List<String>> answerOptions;
    private final Map<String, Object> additionalProperties;

    private LemurQuestion(String question, Optional<LemurQuestionContext> context, Optional<String> answerFormat, Optional<List<String>> answerOptions, Map<String, Object> additionalProperties) {
        this.question = question;
        this.context = context;
        this.answerFormat = answerFormat;
        this.answerOptions = answerOptions;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="question")
    public String getQuestion() {
        return this.question;
    }

    @JsonProperty(value="context")
    public Optional<LemurQuestionContext> getContext() {
        return this.context;
    }

    @JsonProperty(value="answer_format")
    public Optional<String> getAnswerFormat() {
        return this.answerFormat;
    }

    @JsonProperty(value="answer_options")
    public Optional<List<String>> getAnswerOptions() {
        return this.answerOptions;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LemurQuestion && this.equalTo((LemurQuestion)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LemurQuestion other) {
        return this.question.equals(other.question) && this.context.equals(other.context) && this.answerFormat.equals(other.answerFormat) && this.answerOptions.equals(other.answerOptions);
    }

    public int hashCode() {
        return Objects.hash(this.question, this.context, this.answerFormat, this.answerOptions);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static QuestionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements QuestionStage,
    _FinalStage {
        private String question;
        private Optional<List<String>> answerOptions = Optional.empty();
        private Optional<String> answerFormat = Optional.empty();
        private Optional<LemurQuestionContext> context = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LemurQuestion other) {
            this.question(other.getQuestion());
            this.context(other.getContext());
            this.answerFormat(other.getAnswerFormat());
            this.answerOptions(other.getAnswerOptions());
            return this;
        }

        @Override
        @JsonSetter(value="question")
        public _FinalStage question(String question) {
            this.question = question;
            return this;
        }

        @Override
        public _FinalStage answerOptions(List<String> answerOptions) {
            this.answerOptions = Optional.ofNullable(answerOptions);
            return this;
        }

        @Override
        @JsonSetter(value="answer_options", nulls=Nulls.SKIP)
        public _FinalStage answerOptions(Optional<List<String>> answerOptions) {
            this.answerOptions = answerOptions;
            return this;
        }

        @Override
        public _FinalStage answerFormat(String answerFormat) {
            this.answerFormat = Optional.ofNullable(answerFormat);
            return this;
        }

        @Override
        @JsonSetter(value="answer_format", nulls=Nulls.SKIP)
        public _FinalStage answerFormat(Optional<String> answerFormat) {
            this.answerFormat = answerFormat;
            return this;
        }

        @Override
        public _FinalStage context(LemurQuestionContext context) {
            this.context = Optional.ofNullable(context);
            return this;
        }

        @Override
        @JsonSetter(value="context", nulls=Nulls.SKIP)
        public _FinalStage context(Optional<LemurQuestionContext> context) {
            this.context = context;
            return this;
        }

        @Override
        public LemurQuestion build() {
            return new LemurQuestion(this.question, this.context, this.answerFormat, this.answerOptions, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LemurQuestion build();

        public _FinalStage context(Optional<LemurQuestionContext> var1);

        public _FinalStage context(LemurQuestionContext var1);

        public _FinalStage answerFormat(Optional<String> var1);

        public _FinalStage answerFormat(String var1);

        public _FinalStage answerOptions(Optional<List<String>> var1);

        public _FinalStage answerOptions(List<String> var1);
    }

    public static interface QuestionStage {
        public _FinalStage question(String var1);

        public Builder from(LemurQuestion var1);
    }
}

