/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.lemur.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LemurQuestionAnswer {
    private final String question;
    private final String answer;
    private final Map<String, Object> additionalProperties;

    private LemurQuestionAnswer(String question, String answer, Map<String, Object> additionalProperties) {
        this.question = question;
        this.answer = answer;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="question")
    public String getQuestion() {
        return this.question;
    }

    @JsonProperty(value="answer")
    public String getAnswer() {
        return this.answer;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LemurQuestionAnswer && this.equalTo((LemurQuestionAnswer)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LemurQuestionAnswer other) {
        return this.question.equals(other.question) && this.answer.equals(other.answer);
    }

    public int hashCode() {
        return Objects.hash(this.question, this.answer);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static QuestionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements QuestionStage,
    AnswerStage,
    _FinalStage {
        private String question;
        private String answer;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LemurQuestionAnswer other) {
            this.question(other.getQuestion());
            this.answer(other.getAnswer());
            return this;
        }

        @Override
        @JsonSetter(value="question")
        public AnswerStage question(String question) {
            this.question = question;
            return this;
        }

        @Override
        @JsonSetter(value="answer")
        public _FinalStage answer(String answer) {
            this.answer = answer;
            return this;
        }

        @Override
        public LemurQuestionAnswer build() {
            return new LemurQuestionAnswer(this.question, this.answer, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LemurQuestionAnswer build();
    }

    public static interface AnswerStage {
        public _FinalStage answer(String var1);
    }

    public static interface QuestionStage {
        public AnswerStage question(String var1);

        public Builder from(LemurQuestionAnswer var1);
    }
}

