/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.realtime;

import com.assemblyai.api.core.AssemblyAIApiException;
import com.assemblyai.api.core.AssemblyAIException;
import com.assemblyai.api.core.ClientOptions;
import com.assemblyai.api.core.MediaTypes;
import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.core.RequestOptions;
import com.assemblyai.api.errors.BadRequestError;
import com.assemblyai.api.errors.GatewayTimeoutError;
import com.assemblyai.api.errors.InternalServerError;
import com.assemblyai.api.errors.NotFoundError;
import com.assemblyai.api.errors.ServiceUnavailableError;
import com.assemblyai.api.errors.TooManyRequestsError;
import com.assemblyai.api.errors.UnauthorizedError;
import com.assemblyai.api.resources.realtime.requests.CreateRealtimeTemporaryTokenParams;
import com.assemblyai.api.resources.realtime.types.RealtimeTemporaryTokenResponse;
import com.assemblyai.api.types.Error;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RealtimeClient {
    protected final ClientOptions clientOptions;

    public RealtimeClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public RealtimeTemporaryTokenResponse createTemporaryToken(CreateRealtimeTemporaryTokenParams request) {
        return this.createTemporaryToken(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RealtimeTemporaryTokenResponse createTemporaryToken(CreateRealtimeTemporaryTokenParams request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/realtime/token").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new AssemblyAIException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                RealtimeTemporaryTokenResponse realtimeTemporaryTokenResponse = (RealtimeTemporaryTokenResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), RealtimeTemporaryTokenResponse.class);
                return realtimeTemporaryTokenResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 404: {
                        throw new NotFoundError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 429: {
                        throw new TooManyRequestsError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 500: {
                        throw new InternalServerError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 503: {
                        throw new ServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new GatewayTimeoutError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new AssemblyAIException("Network error executing HTTP request", e);
        }
    }
}

