/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.realtime.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.realtime.types.MessageType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RealtimeBaseMessage {
    private final MessageType messageType;
    private final Map<String, Object> additionalProperties;

    private RealtimeBaseMessage(MessageType messageType, Map<String, Object> additionalProperties) {
        this.messageType = messageType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="message_type")
    public MessageType getMessageType() {
        return this.messageType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RealtimeBaseMessage && this.equalTo((RealtimeBaseMessage)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RealtimeBaseMessage other) {
        return this.messageType.equals(other.messageType);
    }

    public int hashCode() {
        return Objects.hash(this.messageType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MessageTypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements MessageTypeStage,
    _FinalStage {
        private MessageType messageType;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(RealtimeBaseMessage other) {
            this.messageType(other.getMessageType());
            return this;
        }

        @Override
        @JsonSetter(value="message_type")
        public _FinalStage messageType(MessageType messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public RealtimeBaseMessage build() {
            return new RealtimeBaseMessage(this.messageType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public RealtimeBaseMessage build();
    }

    public static interface MessageTypeStage {
        public _FinalStage messageType(MessageType var1);

        public Builder from(RealtimeBaseMessage var1);
    }
}

