/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts;

import com.assemblyai.api.core.AssemblyAIApiException;
import com.assemblyai.api.core.AssemblyAIException;
import com.assemblyai.api.core.ClientOptions;
import com.assemblyai.api.core.MediaTypes;
import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.core.RequestOptions;
import com.assemblyai.api.errors.BadRequestError;
import com.assemblyai.api.errors.GatewayTimeoutError;
import com.assemblyai.api.errors.InternalServerError;
import com.assemblyai.api.errors.NotFoundError;
import com.assemblyai.api.errors.ServiceUnavailableError;
import com.assemblyai.api.errors.TooManyRequestsError;
import com.assemblyai.api.errors.UnauthorizedError;
import com.assemblyai.api.resources.transcripts.requests.GetSubtitlesParams;
import com.assemblyai.api.resources.transcripts.requests.ListTranscriptParams;
import com.assemblyai.api.resources.transcripts.requests.TranscriptParams;
import com.assemblyai.api.resources.transcripts.requests.WordSearchParams;
import com.assemblyai.api.resources.transcripts.types.ParagraphsResponse;
import com.assemblyai.api.resources.transcripts.types.RedactedAudioResponse;
import com.assemblyai.api.resources.transcripts.types.SentencesResponse;
import com.assemblyai.api.resources.transcripts.types.SubtitleFormat;
import com.assemblyai.api.resources.transcripts.types.Transcript;
import com.assemblyai.api.resources.transcripts.types.TranscriptList;
import com.assemblyai.api.resources.transcripts.types.WordSearchResponse;
import com.assemblyai.api.types.Error;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class TranscriptsClient {
    protected final ClientOptions clientOptions;

    public TranscriptsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public TranscriptList list() {
        return this.list(ListTranscriptParams.builder().build());
    }

    public TranscriptList list(ListTranscriptParams request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TranscriptList list(ListTranscriptParams request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/transcript");
        if (request.getLimit().isPresent()) {
            httpUrl.addQueryParameter("limit", request.getLimit().get().toString());
        }
        if (request.getStatus().isPresent()) {
            httpUrl.addQueryParameter("status", request.getStatus().get().toString());
        }
        if (request.getCreatedOn().isPresent()) {
            httpUrl.addQueryParameter("created_on", request.getCreatedOn().get());
        }
        if (request.getBeforeId().isPresent()) {
            httpUrl.addQueryParameter("before_id", request.getBeforeId().get());
        }
        if (request.getAfterId().isPresent()) {
            httpUrl.addQueryParameter("after_id", request.getAfterId().get());
        }
        if (request.getThrottledOnly().isPresent()) {
            httpUrl.addQueryParameter("throttled_only", request.getThrottledOnly().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                TranscriptList transcriptList = (TranscriptList)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), TranscriptList.class);
                return transcriptList;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 404: {
                        throw new NotFoundError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 429: {
                        throw new TooManyRequestsError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 500: {
                        throw new InternalServerError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 503: {
                        throw new ServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new GatewayTimeoutError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new AssemblyAIException("Network error executing HTTP request", e);
        }
    }

    public Transcript submit(TranscriptParams request) {
        return this.submit(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Transcript submit(TranscriptParams request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/transcript").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new AssemblyAIException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                Transcript transcript = (Transcript)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), Transcript.class);
                return transcript;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 404: {
                        throw new NotFoundError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 429: {
                        throw new TooManyRequestsError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 500: {
                        throw new InternalServerError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 503: {
                        throw new ServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new GatewayTimeoutError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new AssemblyAIException("Network error executing HTTP request", e);
        }
    }

    public Transcript get(String transcriptId) {
        return this.get(transcriptId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Transcript get(String transcriptId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/transcript").addPathSegment(transcriptId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                Transcript transcript = (Transcript)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), Transcript.class);
                return transcript;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 404: {
                        throw new NotFoundError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 429: {
                        throw new TooManyRequestsError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 500: {
                        throw new InternalServerError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 503: {
                        throw new ServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new GatewayTimeoutError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new AssemblyAIException("Network error executing HTTP request", e);
        }
    }

    public Transcript delete(String transcriptId) {
        return this.delete(transcriptId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Transcript delete(String transcriptId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/transcript").addPathSegment(transcriptId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                Transcript transcript = (Transcript)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), Transcript.class);
                return transcript;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 404: {
                        throw new NotFoundError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 429: {
                        throw new TooManyRequestsError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 500: {
                        throw new InternalServerError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 503: {
                        throw new ServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new GatewayTimeoutError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new AssemblyAIException("Network error executing HTTP request", e);
        }
    }

    public String getSubtitles(String transcriptId, SubtitleFormat subtitleFormat) {
        return this.getSubtitles(transcriptId, subtitleFormat, GetSubtitlesParams.builder().build());
    }

    public String getSubtitles(String transcriptId, SubtitleFormat subtitleFormat, GetSubtitlesParams request) {
        return this.getSubtitles(transcriptId, subtitleFormat, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSubtitles(String transcriptId, SubtitleFormat subtitleFormat, GetSubtitlesParams request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/transcript").addPathSegment(transcriptId).addPathSegment(subtitleFormat.toString());
        if (request.getCharsPerCaption().isPresent()) {
            httpUrl.addQueryParameter("chars_per_caption", request.getCharsPerCaption().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                String string = responseBody.string();
                return string;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 404: {
                        throw new NotFoundError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 429: {
                        throw new TooManyRequestsError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 500: {
                        throw new InternalServerError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 503: {
                        throw new ServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new GatewayTimeoutError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new AssemblyAIException("Network error executing HTTP request", e);
        }
    }

    public SentencesResponse getSentences(String transcriptId) {
        return this.getSentences(transcriptId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SentencesResponse getSentences(String transcriptId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/transcript").addPathSegment(transcriptId).addPathSegments("sentences").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SentencesResponse sentencesResponse = (SentencesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), SentencesResponse.class);
                return sentencesResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 404: {
                        throw new NotFoundError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 429: {
                        throw new TooManyRequestsError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 500: {
                        throw new InternalServerError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 503: {
                        throw new ServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new GatewayTimeoutError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new AssemblyAIException("Network error executing HTTP request", e);
        }
    }

    public ParagraphsResponse getParagraphs(String transcriptId) {
        return this.getParagraphs(transcriptId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ParagraphsResponse getParagraphs(String transcriptId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/transcript").addPathSegment(transcriptId).addPathSegments("paragraphs").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ParagraphsResponse paragraphsResponse = (ParagraphsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ParagraphsResponse.class);
                return paragraphsResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 404: {
                        throw new NotFoundError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 429: {
                        throw new TooManyRequestsError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 500: {
                        throw new InternalServerError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 503: {
                        throw new ServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new GatewayTimeoutError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new AssemblyAIException("Network error executing HTTP request", e);
        }
    }

    public WordSearchResponse wordSearch(String transcriptId) {
        return this.wordSearch(transcriptId, WordSearchParams.builder().build());
    }

    public WordSearchResponse wordSearch(String transcriptId, WordSearchParams request) {
        return this.wordSearch(transcriptId, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WordSearchResponse wordSearch(String transcriptId, WordSearchParams request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/transcript").addPathSegment(transcriptId).addPathSegments("word-search");
        if (request.getWords().isPresent()) {
            httpUrl.addQueryParameter("words", request.getWords().get());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                WordSearchResponse wordSearchResponse = (WordSearchResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), WordSearchResponse.class);
                return wordSearchResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 404: {
                        throw new NotFoundError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 429: {
                        throw new TooManyRequestsError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 500: {
                        throw new InternalServerError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 503: {
                        throw new ServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new GatewayTimeoutError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new AssemblyAIException("Network error executing HTTP request", e);
        }
    }

    public RedactedAudioResponse getRedactedAudio(String transcriptId) {
        return this.getRedactedAudio(transcriptId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RedactedAudioResponse getRedactedAudio(String transcriptId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/transcript").addPathSegment(transcriptId).addPathSegments("redacted-audio").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                RedactedAudioResponse redactedAudioResponse = (RedactedAudioResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), RedactedAudioResponse.class);
                return redactedAudioResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 404: {
                        throw new NotFoundError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 429: {
                        throw new TooManyRequestsError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 500: {
                        throw new InternalServerError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class));
                    }
                    case 503: {
                        throw new ServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new GatewayTimeoutError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new AssemblyAIApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new AssemblyAIException("Network error executing HTTP request", e);
        }
    }
}

