/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContentSafetyLabel {
    private final String label;
    private final double confidence;
    private final double severity;
    private final Map<String, Object> additionalProperties;

    private ContentSafetyLabel(String label, double confidence, double severity, Map<String, Object> additionalProperties) {
        this.label = label;
        this.confidence = confidence;
        this.severity = severity;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="label")
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="confidence")
    public double getConfidence() {
        return this.confidence;
    }

    @JsonProperty(value="severity")
    public double getSeverity() {
        return this.severity;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContentSafetyLabel && this.equalTo((ContentSafetyLabel)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContentSafetyLabel other) {
        return this.label.equals(other.label) && this.confidence == other.confidence && this.severity == other.severity;
    }

    public int hashCode() {
        return Objects.hash(this.label, this.confidence, this.severity);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LabelStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LabelStage,
    ConfidenceStage,
    SeverityStage,
    _FinalStage {
        private String label;
        private double confidence;
        private double severity;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ContentSafetyLabel other) {
            this.label(other.getLabel());
            this.confidence(other.getConfidence());
            this.severity(other.getSeverity());
            return this;
        }

        @Override
        @JsonSetter(value="label")
        public ConfidenceStage label(String label) {
            this.label = label;
            return this;
        }

        @Override
        @JsonSetter(value="confidence")
        public SeverityStage confidence(double confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        @JsonSetter(value="severity")
        public _FinalStage severity(double severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public ContentSafetyLabel build() {
            return new ContentSafetyLabel(this.label, this.confidence, this.severity, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ContentSafetyLabel build();
    }

    public static interface SeverityStage {
        public _FinalStage severity(double var1);
    }

    public static interface ConfidenceStage {
        public SeverityStage confidence(double var1);
    }

    public static interface LabelStage {
        public ConfidenceStage label(String var1);

        public Builder from(ContentSafetyLabel var1);
    }
}

