/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.transcripts.types.ContentSafetyLabel;
import com.assemblyai.api.resources.transcripts.types.Timestamp;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContentSafetyLabelResult {
    private final String text;
    private final List<ContentSafetyLabel> labels;
    private final int sentencesIdxStart;
    private final int sentencesIdxEnd;
    private final Timestamp timestamp;
    private final Map<String, Object> additionalProperties;

    private ContentSafetyLabelResult(String text, List<ContentSafetyLabel> labels, int sentencesIdxStart, int sentencesIdxEnd, Timestamp timestamp, Map<String, Object> additionalProperties) {
        this.text = text;
        this.labels = labels;
        this.sentencesIdxStart = sentencesIdxStart;
        this.sentencesIdxEnd = sentencesIdxEnd;
        this.timestamp = timestamp;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="labels")
    public List<ContentSafetyLabel> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="sentences_idx_start")
    public int getSentencesIdxStart() {
        return this.sentencesIdxStart;
    }

    @JsonProperty(value="sentences_idx_end")
    public int getSentencesIdxEnd() {
        return this.sentencesIdxEnd;
    }

    @JsonProperty(value="timestamp")
    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContentSafetyLabelResult && this.equalTo((ContentSafetyLabelResult)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContentSafetyLabelResult other) {
        return this.text.equals(other.text) && this.labels.equals(other.labels) && this.sentencesIdxStart == other.sentencesIdxStart && this.sentencesIdxEnd == other.sentencesIdxEnd && this.timestamp.equals(other.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.labels, this.sentencesIdxStart, this.sentencesIdxEnd, this.timestamp);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TextStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TextStage,
    SentencesIdxStartStage,
    SentencesIdxEndStage,
    TimestampStage,
    _FinalStage {
        private String text;
        private int sentencesIdxStart;
        private int sentencesIdxEnd;
        private Timestamp timestamp;
        private List<ContentSafetyLabel> labels = new ArrayList<ContentSafetyLabel>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ContentSafetyLabelResult other) {
            this.text(other.getText());
            this.labels(other.getLabels());
            this.sentencesIdxStart(other.getSentencesIdxStart());
            this.sentencesIdxEnd(other.getSentencesIdxEnd());
            this.timestamp(other.getTimestamp());
            return this;
        }

        @Override
        @JsonSetter(value="text")
        public SentencesIdxStartStage text(String text) {
            this.text = text;
            return this;
        }

        @Override
        @JsonSetter(value="sentences_idx_start")
        public SentencesIdxEndStage sentencesIdxStart(int sentencesIdxStart) {
            this.sentencesIdxStart = sentencesIdxStart;
            return this;
        }

        @Override
        @JsonSetter(value="sentences_idx_end")
        public TimestampStage sentencesIdxEnd(int sentencesIdxEnd) {
            this.sentencesIdxEnd = sentencesIdxEnd;
            return this;
        }

        @Override
        @JsonSetter(value="timestamp")
        public _FinalStage timestamp(Timestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public _FinalStage addAllLabels(List<ContentSafetyLabel> labels) {
            this.labels.addAll(labels);
            return this;
        }

        @Override
        public _FinalStage addLabels(ContentSafetyLabel labels) {
            this.labels.add(labels);
            return this;
        }

        @Override
        @JsonSetter(value="labels", nulls=Nulls.SKIP)
        public _FinalStage labels(List<ContentSafetyLabel> labels) {
            this.labels.clear();
            this.labels.addAll(labels);
            return this;
        }

        @Override
        public ContentSafetyLabelResult build() {
            return new ContentSafetyLabelResult(this.text, this.labels, this.sentencesIdxStart, this.sentencesIdxEnd, this.timestamp, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ContentSafetyLabelResult build();

        public _FinalStage labels(List<ContentSafetyLabel> var1);

        public _FinalStage addLabels(ContentSafetyLabel var1);

        public _FinalStage addAllLabels(List<ContentSafetyLabel> var1);
    }

    public static interface TimestampStage {
        public _FinalStage timestamp(Timestamp var1);
    }

    public static interface SentencesIdxEndStage {
        public TimestampStage sentencesIdxEnd(int var1);
    }

    public static interface SentencesIdxStartStage {
        public SentencesIdxEndStage sentencesIdxStart(int var1);
    }

    public static interface TextStage {
        public SentencesIdxStartStage text(String var1);

        public Builder from(ContentSafetyLabelResult var1);
    }
}

