/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.transcripts.types.AudioIntelligenceModelStatus;
import com.assemblyai.api.resources.transcripts.types.TopicDetectionResult;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TopicDetectionModelResult {
    private final AudioIntelligenceModelStatus status;
    private final List<TopicDetectionResult> results;
    private final Map<String, Double> summary;
    private final Map<String, Object> additionalProperties;

    private TopicDetectionModelResult(AudioIntelligenceModelStatus status, List<TopicDetectionResult> results, Map<String, Double> summary, Map<String, Object> additionalProperties) {
        this.status = status;
        this.results = results;
        this.summary = summary;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="status")
    public AudioIntelligenceModelStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="results")
    public List<TopicDetectionResult> getResults() {
        return this.results;
    }

    @JsonProperty(value="summary")
    public Map<String, Double> getSummary() {
        return this.summary;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TopicDetectionModelResult && this.equalTo((TopicDetectionModelResult)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TopicDetectionModelResult other) {
        return this.status.equals(other.status) && this.results.equals(other.results) && this.summary.equals(other.summary);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.results, this.summary);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static StatusStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements StatusStage,
    _FinalStage {
        private AudioIntelligenceModelStatus status;
        private Map<String, Double> summary = new LinkedHashMap<String, Double>();
        private List<TopicDetectionResult> results = new ArrayList<TopicDetectionResult>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TopicDetectionModelResult other) {
            this.status(other.getStatus());
            this.results(other.getResults());
            this.summary(other.getSummary());
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public _FinalStage status(AudioIntelligenceModelStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage summary(String key, Double value) {
            this.summary.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllSummary(Map<String, Double> summary) {
            this.summary.putAll(summary);
            return this;
        }

        @Override
        @JsonSetter(value="summary", nulls=Nulls.SKIP)
        public _FinalStage summary(Map<String, Double> summary) {
            this.summary.clear();
            this.summary.putAll(summary);
            return this;
        }

        @Override
        public _FinalStage addAllResults(List<TopicDetectionResult> results) {
            this.results.addAll(results);
            return this;
        }

        @Override
        public _FinalStage addResults(TopicDetectionResult results) {
            this.results.add(results);
            return this;
        }

        @Override
        @JsonSetter(value="results", nulls=Nulls.SKIP)
        public _FinalStage results(List<TopicDetectionResult> results) {
            this.results.clear();
            this.results.addAll(results);
            return this;
        }

        @Override
        public TopicDetectionModelResult build() {
            return new TopicDetectionModelResult(this.status, this.results, this.summary, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TopicDetectionModelResult build();

        public _FinalStage results(List<TopicDetectionResult> var1);

        public _FinalStage addResults(TopicDetectionResult var1);

        public _FinalStage addAllResults(List<TopicDetectionResult> var1);

        public _FinalStage summary(Map<String, Double> var1);

        public _FinalStage putAllSummary(Map<String, Double> var1);

        public _FinalStage summary(String var1, Double var2);
    }

    public static interface StatusStage {
        public _FinalStage status(AudioIntelligenceModelStatus var1);

        public Builder from(TopicDetectionModelResult var1);
    }
}

