/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.transcripts.types.PageDetails;
import com.assemblyai.api.resources.transcripts.types.TranscriptListItem;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TranscriptList {
    private final PageDetails pageDetails;
    private final List<TranscriptListItem> transcripts;
    private final Map<String, Object> additionalProperties;

    private TranscriptList(PageDetails pageDetails, List<TranscriptListItem> transcripts, Map<String, Object> additionalProperties) {
        this.pageDetails = pageDetails;
        this.transcripts = transcripts;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="page_details")
    public PageDetails getPageDetails() {
        return this.pageDetails;
    }

    @JsonProperty(value="transcripts")
    public List<TranscriptListItem> getTranscripts() {
        return this.transcripts;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TranscriptList && this.equalTo((TranscriptList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TranscriptList other) {
        return this.pageDetails.equals(other.pageDetails) && this.transcripts.equals(other.transcripts);
    }

    public int hashCode() {
        return Objects.hash(this.pageDetails, this.transcripts);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PageDetailsStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PageDetailsStage,
    _FinalStage {
        private PageDetails pageDetails;
        private List<TranscriptListItem> transcripts = new ArrayList<TranscriptListItem>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TranscriptList other) {
            this.pageDetails(other.getPageDetails());
            this.transcripts(other.getTranscripts());
            return this;
        }

        @Override
        @JsonSetter(value="page_details")
        public _FinalStage pageDetails(PageDetails pageDetails) {
            this.pageDetails = pageDetails;
            return this;
        }

        @Override
        public _FinalStage addAllTranscripts(List<TranscriptListItem> transcripts) {
            this.transcripts.addAll(transcripts);
            return this;
        }

        @Override
        public _FinalStage addTranscripts(TranscriptListItem transcripts) {
            this.transcripts.add(transcripts);
            return this;
        }

        @Override
        @JsonSetter(value="transcripts", nulls=Nulls.SKIP)
        public _FinalStage transcripts(List<TranscriptListItem> transcripts) {
            this.transcripts.clear();
            this.transcripts.addAll(transcripts);
            return this;
        }

        @Override
        public TranscriptList build() {
            return new TranscriptList(this.pageDetails, this.transcripts, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TranscriptList build();

        public _FinalStage transcripts(List<TranscriptListItem> var1);

        public _FinalStage addTranscripts(TranscriptListItem var1);

        public _FinalStage addAllTranscripts(List<TranscriptListItem> var1);
    }

    public static interface PageDetailsStage {
        public _FinalStage pageDetails(PageDetails var1);

        public Builder from(TranscriptList var1);
    }
}

