/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.transcripts.types.TranscriptStatus;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TranscriptListItem {
    private final String id;
    private final String resourceUrl;
    private final TranscriptStatus status;
    private final OffsetDateTime created;
    private final Optional<OffsetDateTime> completed;
    private final String audioUrl;
    private final Optional<String> error;
    private final Map<String, Object> additionalProperties;

    private TranscriptListItem(String id, String resourceUrl, TranscriptStatus status, OffsetDateTime created, Optional<OffsetDateTime> completed, String audioUrl, Optional<String> error, Map<String, Object> additionalProperties) {
        this.id = id;
        this.resourceUrl = resourceUrl;
        this.status = status;
        this.created = created;
        this.completed = completed;
        this.audioUrl = audioUrl;
        this.error = error;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="resource_url")
    public String getResourceUrl() {
        return this.resourceUrl;
    }

    @JsonProperty(value="status")
    public TranscriptStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="created")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @JsonProperty(value="completed")
    public Optional<OffsetDateTime> getCompleted() {
        return this.completed;
    }

    @JsonProperty(value="audio_url")
    public String getAudioUrl() {
        return this.audioUrl;
    }

    @JsonProperty(value="error")
    public Optional<String> getError() {
        return this.error;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TranscriptListItem && this.equalTo((TranscriptListItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TranscriptListItem other) {
        return this.id.equals(other.id) && this.resourceUrl.equals(other.resourceUrl) && this.status.equals(other.status) && this.created.equals(other.created) && this.completed.equals(other.completed) && this.audioUrl.equals(other.audioUrl) && this.error.equals(other.error);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.resourceUrl, this.status, this.created, this.completed, this.audioUrl, this.error);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    ResourceUrlStage,
    StatusStage,
    CreatedStage,
    AudioUrlStage,
    _FinalStage {
        private String id;
        private String resourceUrl;
        private TranscriptStatus status;
        private OffsetDateTime created;
        private String audioUrl;
        private Optional<String> error = Optional.empty();
        private Optional<OffsetDateTime> completed = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TranscriptListItem other) {
            this.id(other.getId());
            this.resourceUrl(other.getResourceUrl());
            this.status(other.getStatus());
            this.created(other.getCreated());
            this.completed(other.getCompleted());
            this.audioUrl(other.getAudioUrl());
            this.error(other.getError());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public ResourceUrlStage id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @JsonSetter(value="resource_url")
        public StatusStage resourceUrl(String resourceUrl) {
            this.resourceUrl = resourceUrl;
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public CreatedStage status(TranscriptStatus status) {
            this.status = status;
            return this;
        }

        @Override
        @JsonSetter(value="created")
        public AudioUrlStage created(OffsetDateTime created) {
            this.created = created;
            return this;
        }

        @Override
        @JsonSetter(value="audio_url")
        public _FinalStage audioUrl(String audioUrl) {
            this.audioUrl = audioUrl;
            return this;
        }

        @Override
        public _FinalStage error(String error) {
            this.error = Optional.ofNullable(error);
            return this;
        }

        @Override
        @JsonSetter(value="error", nulls=Nulls.SKIP)
        public _FinalStage error(Optional<String> error) {
            this.error = error;
            return this;
        }

        @Override
        public _FinalStage completed(OffsetDateTime completed) {
            this.completed = Optional.ofNullable(completed);
            return this;
        }

        @Override
        @JsonSetter(value="completed", nulls=Nulls.SKIP)
        public _FinalStage completed(Optional<OffsetDateTime> completed) {
            this.completed = completed;
            return this;
        }

        @Override
        public TranscriptListItem build() {
            return new TranscriptListItem(this.id, this.resourceUrl, this.status, this.created, this.completed, this.audioUrl, this.error, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TranscriptListItem build();

        public _FinalStage completed(Optional<OffsetDateTime> var1);

        public _FinalStage completed(OffsetDateTime var1);

        public _FinalStage error(Optional<String> var1);

        public _FinalStage error(String var1);
    }

    public static interface AudioUrlStage {
        public _FinalStage audioUrl(String var1);
    }

    public static interface CreatedStage {
        public AudioUrlStage created(OffsetDateTime var1);
    }

    public static interface StatusStage {
        public CreatedStage status(TranscriptStatus var1);
    }

    public static interface ResourceUrlStage {
        public StatusStage resourceUrl(String var1);
    }

    public static interface IdStage {
        public ResourceUrlStage id(String var1);

        public Builder from(TranscriptListItem var1);
    }
}

