/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.transcripts.types.TranscriptReadyStatus;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TranscriptReadyNotification {
    private final String transcriptId;
    private final TranscriptReadyStatus status;
    private final Map<String, Object> additionalProperties;

    private TranscriptReadyNotification(String transcriptId, TranscriptReadyStatus status, Map<String, Object> additionalProperties) {
        this.transcriptId = transcriptId;
        this.status = status;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="transcript_id")
    public String getTranscriptId() {
        return this.transcriptId;
    }

    @JsonProperty(value="status")
    public TranscriptReadyStatus getStatus() {
        return this.status;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TranscriptReadyNotification && this.equalTo((TranscriptReadyNotification)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TranscriptReadyNotification other) {
        return this.transcriptId.equals(other.transcriptId) && this.status.equals(other.status);
    }

    public int hashCode() {
        return Objects.hash(this.transcriptId, this.status);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TranscriptIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TranscriptIdStage,
    StatusStage,
    _FinalStage {
        private String transcriptId;
        private TranscriptReadyStatus status;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TranscriptReadyNotification other) {
            this.transcriptId(other.getTranscriptId());
            this.status(other.getStatus());
            return this;
        }

        @Override
        @JsonSetter(value="transcript_id")
        public StatusStage transcriptId(String transcriptId) {
            this.transcriptId = transcriptId;
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public _FinalStage status(TranscriptReadyStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public TranscriptReadyNotification build() {
            return new TranscriptReadyNotification(this.transcriptId, this.status, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TranscriptReadyNotification build();
    }

    public static interface StatusStage {
        public _FinalStage status(TranscriptReadyStatus var1);
    }

    public static interface TranscriptIdStage {
        public StatusStage transcriptId(String var1);

        public Builder from(TranscriptReadyNotification var1);
    }
}

