/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.transcripts.types.TranscriptWord;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TranscriptSentence {
    private final String text;
    private final int start;
    private final int end;
    private final double confidence;
    private final List<TranscriptWord> words;
    private final Optional<String> speaker;
    private final Map<String, Object> additionalProperties;

    private TranscriptSentence(String text, int start, int end, double confidence, List<TranscriptWord> words, Optional<String> speaker, Map<String, Object> additionalProperties) {
        this.text = text;
        this.start = start;
        this.end = end;
        this.confidence = confidence;
        this.words = words;
        this.speaker = speaker;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="start")
    public int getStart() {
        return this.start;
    }

    @JsonProperty(value="end")
    public int getEnd() {
        return this.end;
    }

    @JsonProperty(value="confidence")
    public double getConfidence() {
        return this.confidence;
    }

    @JsonProperty(value="words")
    public List<TranscriptWord> getWords() {
        return this.words;
    }

    @JsonProperty(value="speaker")
    public Optional<String> getSpeaker() {
        return this.speaker;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TranscriptSentence && this.equalTo((TranscriptSentence)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TranscriptSentence other) {
        return this.text.equals(other.text) && this.start == other.start && this.end == other.end && this.confidence == other.confidence && this.words.equals(other.words) && this.speaker.equals(other.speaker);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.start, this.end, this.confidence, this.words, this.speaker);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TextStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TextStage,
    StartStage,
    EndStage,
    ConfidenceStage,
    _FinalStage {
        private String text;
        private int start;
        private int end;
        private double confidence;
        private Optional<String> speaker = Optional.empty();
        private List<TranscriptWord> words = new ArrayList<TranscriptWord>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TranscriptSentence other) {
            this.text(other.getText());
            this.start(other.getStart());
            this.end(other.getEnd());
            this.confidence(other.getConfidence());
            this.words(other.getWords());
            this.speaker(other.getSpeaker());
            return this;
        }

        @Override
        @JsonSetter(value="text")
        public StartStage text(String text) {
            this.text = text;
            return this;
        }

        @Override
        @JsonSetter(value="start")
        public EndStage start(int start) {
            this.start = start;
            return this;
        }

        @Override
        @JsonSetter(value="end")
        public ConfidenceStage end(int end) {
            this.end = end;
            return this;
        }

        @Override
        @JsonSetter(value="confidence")
        public _FinalStage confidence(double confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        public _FinalStage speaker(String speaker) {
            this.speaker = Optional.ofNullable(speaker);
            return this;
        }

        @Override
        @JsonSetter(value="speaker", nulls=Nulls.SKIP)
        public _FinalStage speaker(Optional<String> speaker) {
            this.speaker = speaker;
            return this;
        }

        @Override
        public _FinalStage addAllWords(List<TranscriptWord> words) {
            this.words.addAll(words);
            return this;
        }

        @Override
        public _FinalStage addWords(TranscriptWord words) {
            this.words.add(words);
            return this;
        }

        @Override
        @JsonSetter(value="words", nulls=Nulls.SKIP)
        public _FinalStage words(List<TranscriptWord> words) {
            this.words.clear();
            this.words.addAll(words);
            return this;
        }

        @Override
        public TranscriptSentence build() {
            return new TranscriptSentence(this.text, this.start, this.end, this.confidence, this.words, this.speaker, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TranscriptSentence build();

        public _FinalStage words(List<TranscriptWord> var1);

        public _FinalStage addWords(TranscriptWord var1);

        public _FinalStage addAllWords(List<TranscriptWord> var1);

        public _FinalStage speaker(Optional<String> var1);

        public _FinalStage speaker(String var1);
    }

    public static interface ConfidenceStage {
        public _FinalStage confidence(double var1);
    }

    public static interface EndStage {
        public ConfidenceStage end(int var1);
    }

    public static interface StartStage {
        public EndStage start(int var1);
    }

    public static interface TextStage {
        public StartStage text(String var1);

        public Builder from(TranscriptSentence var1);
    }
}

