/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class WordSearchMatch {
    private final String text;
    private final int count;
    private final List<List<Integer>> timestamps;
    private final List<Integer> indexes;
    private final Map<String, Object> additionalProperties;

    private WordSearchMatch(String text, int count, List<List<Integer>> timestamps, List<Integer> indexes, Map<String, Object> additionalProperties) {
        this.text = text;
        this.count = count;
        this.timestamps = timestamps;
        this.indexes = indexes;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="count")
    public int getCount() {
        return this.count;
    }

    @JsonProperty(value="timestamps")
    public List<List<Integer>> getTimestamps() {
        return this.timestamps;
    }

    @JsonProperty(value="indexes")
    public List<Integer> getIndexes() {
        return this.indexes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof WordSearchMatch && this.equalTo((WordSearchMatch)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(WordSearchMatch other) {
        return this.text.equals(other.text) && this.count == other.count && this.timestamps.equals(other.timestamps) && this.indexes.equals(other.indexes);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.count, this.timestamps, this.indexes);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TextStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TextStage,
    CountStage,
    _FinalStage {
        private String text;
        private int count;
        private List<Integer> indexes = new ArrayList<Integer>();
        private List<List<Integer>> timestamps = new ArrayList<List<Integer>>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(WordSearchMatch other) {
            this.text(other.getText());
            this.count(other.getCount());
            this.timestamps(other.getTimestamps());
            this.indexes(other.getIndexes());
            return this;
        }

        @Override
        @JsonSetter(value="text")
        public CountStage text(String text) {
            this.text = text;
            return this;
        }

        @Override
        @JsonSetter(value="count")
        public _FinalStage count(int count) {
            this.count = count;
            return this;
        }

        @Override
        public _FinalStage addAllIndexes(List<Integer> indexes) {
            this.indexes.addAll(indexes);
            return this;
        }

        @Override
        public _FinalStage addIndexes(Integer indexes) {
            this.indexes.add(indexes);
            return this;
        }

        @Override
        @JsonSetter(value="indexes", nulls=Nulls.SKIP)
        public _FinalStage indexes(List<Integer> indexes) {
            this.indexes.clear();
            this.indexes.addAll(indexes);
            return this;
        }

        @Override
        public _FinalStage addAllTimestamps(List<List<Integer>> timestamps) {
            this.timestamps.addAll(timestamps);
            return this;
        }

        @Override
        public _FinalStage addTimestamps(List<Integer> timestamps) {
            this.timestamps.add(timestamps);
            return this;
        }

        @Override
        @JsonSetter(value="timestamps", nulls=Nulls.SKIP)
        public _FinalStage timestamps(List<List<Integer>> timestamps) {
            this.timestamps.clear();
            this.timestamps.addAll(timestamps);
            return this;
        }

        @Override
        public WordSearchMatch build() {
            return new WordSearchMatch(this.text, this.count, this.timestamps, this.indexes, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public WordSearchMatch build();

        public _FinalStage timestamps(List<List<Integer>> var1);

        public _FinalStage addTimestamps(List<Integer> var1);

        public _FinalStage addAllTimestamps(List<List<Integer>> var1);

        public _FinalStage indexes(List<Integer> var1);

        public _FinalStage addIndexes(Integer var1);

        public _FinalStage addAllIndexes(List<Integer> var1);
    }

    public static interface CountStage {
        public _FinalStage count(int var1);
    }

    public static interface TextStage {
        public CountStage text(String var1);

        public Builder from(WordSearchMatch var1);
    }
}

