/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Error {
    private final String error;
    private final Optional<String> status;
    private final Map<String, Object> additionalProperties;

    private Error(String error, Optional<String> status, Map<String, Object> additionalProperties) {
        this.error = error;
        this.status = status;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="error")
    public String getError() {
        return this.error;
    }

    @JsonProperty(value="status")
    public Optional<String> getStatus() {
        return this.status;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Error && this.equalTo((Error)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Error other) {
        return this.error.equals(other.error) && this.status.equals(other.status);
    }

    public int hashCode() {
        return Objects.hash(this.error, this.status);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ErrorStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ErrorStage,
    _FinalStage {
        private String error;
        private Optional<String> status = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Error other) {
            this.error(other.getError());
            this.status(other.getStatus());
            return this;
        }

        @Override
        @JsonSetter(value="error")
        public _FinalStage error(String error) {
            this.error = error;
            return this;
        }

        @Override
        public _FinalStage status(String status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<String> status) {
            this.status = status;
            return this;
        }

        @Override
        public Error build() {
            return new Error(this.error, this.status, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Error build();

        public _FinalStage status(Optional<String> var1);

        public _FinalStage status(String var1);
    }

    public static interface ErrorStage {
        public _FinalStage error(String var1);

        public Builder from(Error var1);
    }
}

