/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.events;

import com.atlan.cache.CustomMetadataCache;
import com.atlan.events.AtlanEventHandler;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ConflictException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Badge;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.IReadme;
import com.atlan.model.assets.Readme;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.model.enums.AtlanCustomAttributePrimitiveType;
import com.atlan.model.enums.BadgeComparisonOperator;
import com.atlan.model.enums.BadgeConditionColor;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.events.AtlanEvent;
import com.atlan.model.structs.BadgeCondition;
import com.atlan.model.typedefs.AttributeDef;
import com.atlan.model.typedefs.CustomMetadataDef;
import com.atlan.model.typedefs.CustomMetadataOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class DaapScoreCalculator
implements AtlanEventHandler {
    private static final String CM_DAAP = "DaaP";
    private static final String CM_ATTR_DAAP_SCORE = "Score";
    private static final List<String> SCORED_ATTRS = List.of("description", "userDescription", "ownerUsers", "ownerGroups", "meanings", "__hasLineage", "classifications", "inputToProcesses", "outputFromProcesses", "assignedEntities", "seeAlso", "links");
    private static final DaapScoreCalculator INSTANCE = DaapScoreCalculator.createInstance();

    private static DaapScoreCalculator createInstance() {
        return new DaapScoreCalculator();
    }

    public static DaapScoreCalculator getInstance() {
        return INSTANCE;
    }

    public boolean validatePrerequisites(AtlanEvent event, Logger log) {
        return DaapScoreCalculator.createCMIfNotExists(log) != null && event.getPayload() != null && event.getPayload().getAsset() != null;
    }

    public Asset getCurrentState(Asset fromEvent, Logger log) throws AtlanException {
        HashSet<String> searchAttrs = new HashSet<String>(SCORED_ATTRS);
        searchAttrs.addAll(CustomMetadataCache.getAttributesForSearchResults((String)CM_DAAP));
        Asset asset = AtlanEventHandler.getCurrentViewOfAsset((Asset)fromEvent, searchAttrs, (boolean)true, (boolean)true);
        if (asset == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, new String[]{fromEvent.getQualifiedName(), fromEvent.getTypeName()});
        }
        return asset;
    }

    public Collection<Asset> calculateChanges(Asset asset, Logger log) throws AtlanException {
        double score = -1.0;
        if (asset instanceof GlossaryTerm) {
            String description;
            GlossaryTerm term = (GlossaryTerm)asset;
            int sDescription = AtlanEventHandler.hasDescription((Asset)term) ? 15 : 0;
            int sRelatedTerm = term.getSeeAlso() != null && !term.getSeeAlso().isEmpty() ? 10 : 0;
            int sLinks = term.getLinks() != null && !term.getLinks().isEmpty() ? 10 : 0;
            int sRelatedAsset = term.getAssignedEntities() != null && !term.getAssignedEntities().isEmpty() ? 20 : 0;
            int sCertificate = 0;
            if (asset.getCertificateStatus() == CertificateStatus.DRAFT) {
                sCertificate = 15;
            } else if (asset.getCertificateStatus() == CertificateStatus.VERIFIED) {
                sCertificate = 25;
            }
            int sReadme = 0;
            IReadme readme = asset.getReadme();
            if (readme != null && readme.getGuid() != null && (description = (readme = Readme.retrieveByGuid((String)readme.getGuid())).getDescription()) != null) {
                if (description.length() > 1000) {
                    sReadme = 20;
                } else if (description.length() > 500) {
                    sReadme = 10;
                } else if (description.length() > 100) {
                    sReadme = 5;
                }
            }
            score = sDescription + sRelatedTerm + sLinks + sRelatedAsset + sCertificate + sReadme;
        } else if (!asset.getTypeName().startsWith("AtlasGlossary")) {
            int sDescription = AtlanEventHandler.hasDescription((Asset)asset) ? 20 : 0;
            int sOwner = AtlanEventHandler.hasOwner((Asset)asset) ? 20 : 0;
            int sTerms = AtlanEventHandler.hasAssignedTerms((Asset)asset) ? 20 : 0;
            int sTags = AtlanEventHandler.hasAtlanTags((Asset)asset) ? 20 : 0;
            int sLineage = AtlanEventHandler.hasLineage((Asset)asset) ? 20 : 0;
            score = sDescription + sOwner + sLineage + sTerms + sTags;
        }
        if (score >= 0.0) {
            CustomMetadataAttributes cma = CustomMetadataAttributes.builder().attribute(CM_ATTR_DAAP_SCORE, (Object)score).build();
            Asset revised = asset.trimToRequired().customMetadata(CM_DAAP, cma).build();
            return this.hasChanges(asset, revised, log) ? Set.of(revised) : Collections.emptySet();
        }
        return Collections.emptySet();
    }

    public boolean hasChanges(Asset original, Asset modified, Logger log) {
        Map attrs;
        double scoreOriginal = -1.0;
        double scoreModified = -1.0;
        Map customMetadata = original.getCustomMetadataSets();
        if (customMetadata != null && customMetadata.containsKey(CM_DAAP)) {
            attrs = ((CustomMetadataAttributes)customMetadata.get(CM_DAAP)).getAttributes();
            scoreOriginal = attrs.getOrDefault(CM_ATTR_DAAP_SCORE, -1.0);
        }
        if ((customMetadata = modified.getCustomMetadataSets()) != null && customMetadata.containsKey(CM_DAAP)) {
            attrs = ((CustomMetadataAttributes)customMetadata.get(CM_DAAP)).getAttributes();
            scoreModified = attrs.getOrDefault(CM_ATTR_DAAP_SCORE, -1.0);
        }
        return scoreOriginal != scoreModified;
    }

    static String createCMIfNotExists(Logger log) {
        try {
            return CustomMetadataCache.getIdForName((String)CM_DAAP);
        }
        catch (NotFoundException e) {
            try {
                CustomMetadataDef customMetadataDef = ((CustomMetadataDef.CustomMetadataDefBuilder)CustomMetadataDef.creator((String)CM_DAAP).attributeDef(AttributeDef.of((String)CM_ATTR_DAAP_SCORE, (AtlanCustomAttributePrimitiveType)AtlanCustomAttributePrimitiveType.DECIMAL, null, (boolean)false).toBuilder().description("Data as a Product completeness score for this asset").build())).options(CustomMetadataOptions.withLogoAsEmoji((String)"\ud83d\udd16")).build();
                customMetadataDef.create();
                log.info("Created DaaP custom metadata structure.");
                Badge badge = ((Badge.BadgeBuilder)Badge.creator((String)CM_ATTR_DAAP_SCORE, (String)CM_DAAP, (String)CM_ATTR_DAAP_SCORE).userDescription("Data as a Product completeness score. Indicates how enriched and ready for re-use this asset is, out of a total possible score of 100.")).badgeCondition(BadgeCondition.of((BadgeComparisonOperator)BadgeComparisonOperator.GTE, (String)"75", (BadgeConditionColor)BadgeConditionColor.GREEN)).badgeCondition(BadgeCondition.of((BadgeComparisonOperator)BadgeComparisonOperator.LT, (String)"75", (BadgeConditionColor)BadgeConditionColor.YELLOW)).badgeCondition(BadgeCondition.of((BadgeComparisonOperator)BadgeComparisonOperator.LTE, (String)"25", (BadgeConditionColor)BadgeConditionColor.RED)).build();
                try {
                    badge.upsert();
                    log.info("Created DaaP completeness score badge.");
                }
                catch (AtlanException eBadge) {
                    log.error("Unable to create badge over the DaaP score.", (Throwable)eBadge);
                }
                return CustomMetadataCache.getIdForName((String)CM_DAAP);
            }
            catch (ConflictException conflict) {
                try {
                    return CustomMetadataCache.getIdForName((String)CM_DAAP);
                }
                catch (AtlanException eConflict) {
                    log.error("Unable to look up DaaP custom metadata, even though it should already exist.", (Throwable)eConflict);
                }
            }
            catch (AtlanException eStruct) {
                log.error("Unable to create DaaP custom metadata structure.", (Throwable)eStruct);
            }
        }
        catch (AtlanException e) {
            log.error("Unable to look up DaaP custom metadata.", (Throwable)e);
        }
        return null;
    }
}

