/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.events;

import com.atlan.events.AtlanEventHandler;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.enums.CertificateStatus;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public class VerificationEnforcer
implements AtlanEventHandler {
    List<String> REQUIRED_ATTRS = List.of("description", "userDescription", "ownerUsers", "ownerGroups", "__hasLineage", "inputToProcesses", "outputFromProcesses", "certificateStatus");
    String ENFORCEMENT_MESSAGE = "To be verified, an asset must have a description, at least one owner, and lineage.";
    private static final VerificationEnforcer INSTANCE = VerificationEnforcer.createInstance();

    private static VerificationEnforcer createInstance() {
        return new VerificationEnforcer();
    }

    public static VerificationEnforcer getInstance() {
        return INSTANCE;
    }

    public Asset getCurrentState(Asset fromEvent, Logger log) throws AtlanException {
        Asset asset = AtlanEventHandler.getCurrentViewOfAsset((Asset)fromEvent, this.REQUIRED_ATTRS, (boolean)false, (boolean)false);
        if (asset == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, new String[]{fromEvent.getQualifiedName(), fromEvent.getTypeName()});
        }
        return asset;
    }

    public Collection<Asset> calculateChanges(Asset asset, Logger log) throws AtlanException {
        if (asset.getCertificateStatus() == CertificateStatus.VERIFIED) {
            if (!AtlanEventHandler.hasDescription((Asset)asset) || !AtlanEventHandler.hasOwner((Asset)asset) || !asset.getTypeName().startsWith("AtlasGlossary") && !AtlanEventHandler.hasLineage((Asset)asset)) {
                return Set.of(asset.trimToRequired().certificateStatus(CertificateStatus.DRAFT).certificateStatusMessage(this.ENFORCEMENT_MESSAGE).build());
            }
            log.info("Asset has all required information present to be verified, no enforcement required: {}", (Object)asset.getQualifiedName());
        } else {
            log.info("Asset is no longer verified, no enforcement action to consider: {}", (Object)asset.getQualifiedName());
        }
        return Collections.emptySet();
    }
}

