/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders;

import com.atlan.Atlan;
import com.atlan.api.EntityUniqueAttributesEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.core.AtlanTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;

public abstract class AbstractLoader {
    private static final Logger log = LoggerFactory.getLogger(AbstractLoader.class);
    private int _batchSize = 50;
    private String _delimiter = "|";
    private Region _region = null;
    private String _bucket = null;
    private String _filename = null;
    private boolean _updateOnly = false;

    protected void parseParametersFromEvent(Map<String, String> event) {
        if (event != null) {
            log.debug(" ... event: {}", event);
            String batchSize = event.getOrDefault("BATCH_SIZE", "50");
            try {
                this._batchSize = Integer.parseInt(batchSize);
            }
            catch (NumberFormatException e) {
                log.warn("Unable to determine a number from the BATCH_SIZE value of '{}', falling back to a default of 50.", (Object)batchSize);
                this._batchSize = 50;
            }
            String updateOnly = event.getOrDefault("UPDATE_ONLY", "false");
            this._updateOnly = updateOnly.toUpperCase(Locale.ROOT).equals("TRUE");
            this._delimiter = event.getOrDefault("DELIMITER", "|");
            String region = event.getOrDefault("REGION", "ap-south-1");
            this._region = Region.of((String)region);
            this._bucket = event.getOrDefault("BUCKET", null);
            this._filename = event.getOrDefault("FILENAME", "atlan-documentation-template.xlsx");
            Atlan.setBaseUrl((String)event.getOrDefault("ATLAN_BASE_URL", null));
            Atlan.setApiToken((String)event.getOrDefault("ATLAN_API_KEY", null));
            String maxRetries = event.getOrDefault("MAX_RETRIES", "20");
            int _maxRetries = 20;
            try {
                _maxRetries = Integer.parseInt(maxRetries);
            }
            catch (NumberFormatException e) {
                log.warn("Unable to determine a number from the MAX_RETRIES value of '{}', falling back to a default of 20.", (Object)maxRetries);
            }
            Atlan.setMaxNetworkRetries((int)_maxRetries);
        }
    }

    protected void appendAtlanTags(Map<String, List<String>> assetMap, String typeName) {
        List<Object> atlanTags;
        String qn;
        HashMap<String, List<Object>> toRetag = new HashMap<String, List<Object>>();
        if (!assetMap.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : assetMap.entrySet()) {
                qn = entry.getKey();
                atlanTags = new ArrayList(entry.getValue());
                try {
                    Asset column = Asset.retrieveMinimal((String)typeName, (String)qn);
                    SortedSet existing = column.getAtlanTags();
                    ArrayList<String> toRemove = new ArrayList<String>();
                    for (AtlanTag one : existing) {
                        if (!atlanTags.contains(one.getTypeName())) continue;
                        toRemove.add(one.getTypeName());
                    }
                    atlanTags.removeAll(toRemove);
                    if (atlanTags.isEmpty()) continue;
                    toRetag.put(qn, atlanTags);
                }
                catch (AtlanException e) {
                    log.error("Unable to find {} {} \u2014 cannot retag it.", new Object[]{typeName, qn, e});
                }
            }
        }
        if (!toRetag.isEmpty()) {
            log.info("... tagging {} {}s:", (Object)toRetag.size(), (Object)typeName);
            for (Map.Entry<String, List<String>> entry : toRetag.entrySet()) {
                qn = entry.getKey();
                atlanTags = entry.getValue();
                try {
                    log.info("...... tagging: {}", (Object)qn);
                    EntityUniqueAttributesEndpoint.addAtlanTags((String)typeName, (String)qn, atlanTags);
                }
                catch (AtlanException e) {
                    log.error("Unable to tag {} {} with: {}", new Object[]{typeName, qn, atlanTags, e});
                }
            }
        }
    }

    public void setFilename(String _filename) {
        this._filename = _filename;
    }

    public String getFilename() {
        return this._filename;
    }

    public String getBucket() {
        return this._bucket;
    }

    public Region getRegion() {
        return this._region;
    }

    public int getBatchSize() {
        return this._batchSize;
    }

    public String getDelimiter() {
        return this._delimiter;
    }

    public boolean isUpdateOnly() {
        return this._updateOnly;
    }
}

