/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.Database;
import com.atlan.model.assets.GCSBucket;
import com.atlan.model.assets.MaterializedView;
import com.atlan.model.assets.S3Bucket;
import com.atlan.model.assets.Schema;
import com.atlan.model.assets.Table;
import com.atlan.model.assets.View;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.samples.loaders.AbstractLoader;
import com.atlan.samples.loaders.models.AccountDetails;
import com.atlan.samples.loaders.models.AssetDetails;
import com.atlan.samples.loaders.models.BucketDetails;
import com.atlan.samples.loaders.models.ColumnDetails;
import com.atlan.samples.loaders.models.ConnectionDetails;
import com.atlan.samples.loaders.models.ContainerDetails;
import com.atlan.samples.loaders.models.DatabaseDetails;
import com.atlan.samples.loaders.models.LineageDetails;
import com.atlan.samples.loaders.models.ObjectDetails;
import com.atlan.samples.loaders.models.SchemaDetails;
import com.atlan.samples.readers.ExcelReader;
import com.atlan.util.AssetBatch;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentationTemplateLoader
extends AbstractLoader
implements RequestHandler<Map<String, String>, String> {
    private static final Logger log = LoggerFactory.getLogger(DocumentationTemplateLoader.class);
    private static final String TABULAR_SHEET = "Tabular Assets";
    private static final String OBJECT_SHEET = "Object Store Assets";
    private static final String LINEAGE_SHEET = "Lineage";

    public static void main(String[] args) {
        DocumentationTemplateLoader dtl = new DocumentationTemplateLoader();
        HashMap<String, String> event = new HashMap<String, String>(System.getenv());
        if (!event.containsKey("FILENAME")) {
            event.put("FILENAME", "atlan-documentation-template.xlsx");
        }
        dtl.handleRequest(event, null);
    }

    public String handleRequest(Map<String, String> event, Context context) {
        try {
            log.info("Retrieving configuration and context...");
            if (context != null && context.getClientContext() != null) {
                log.debug(" ... client environment: {}", (Object)context.getClientContext().getEnvironment());
                log.debug(" ... client custom: {}", (Object)context.getClientContext().getCustom());
            }
            this.parseParametersFromEvent(event);
            ExcelReader xlsx = new ExcelReader(this.getFilename());
            try {
                this.processTabularAssets(xlsx);
            }
            catch (IOException e) {
                log.warn("Could not find sheet: {} \u2014 skipping", (Object)TABULAR_SHEET);
            }
            try {
                this.processObjectStoreAssets(xlsx);
            }
            catch (IOException e) {
                log.warn("Could not find sheet: {} \u2014 skipping", (Object)OBJECT_SHEET);
            }
            try {
                this.processLineage(xlsx);
            }
            catch (IOException e) {
                log.warn("Could not find sheet: {} \u2014 skipping", (Object)LINEAGE_SHEET);
            }
        }
        catch (IOException e) {
            log.error("Failed to read Excel file from: {}", (Object)this.getFilename(), (Object)e);
            System.exit(1);
        }
        return this.getFilename();
    }

    public void processTabularAssets(ExcelReader xlsx) throws IOException {
        Schema toUpdate;
        log.info("Loading tabular assets from: {}::{}", (Object)this.getFilename(), (Object)TABULAR_SHEET);
        List<Map<String, String>> data = xlsx.getRowsFromSheet(TABULAR_SHEET, 1);
        LinkedHashMap<String, ConnectionDetails> connections = new LinkedHashMap<String, ConnectionDetails>();
        for (Map<String, String> row : data) {
            String string;
            ConnectionDetails connectionDetails;
            ConnectionDetails details = ConnectionDetails.getFromRow(row, this.getDelimiter());
            if (details == null || (connectionDetails = (ConnectionDetails)connections.get(string = details.getIdentity())) != null && !connectionDetails.isStub()) continue;
            connections.put(string, details);
        }
        Map<ConnectionDetails, String> connectionCache = ConnectionDetails.upsert(connections, this.getBatchSize(), this.isUpdateOnly());
        LinkedHashMap<String, DatabaseDetails> databases = new LinkedHashMap<String, DatabaseDetails>();
        for (Map map : data) {
            String identity;
            DatabaseDetails databaseDetails;
            DatabaseDetails databaseDetails2 = DatabaseDetails.getFromRow(connectionCache, (Map<String, String>)map, this.getDelimiter());
            if (databaseDetails2 == null || (databaseDetails = (DatabaseDetails)databases.get(identity = databaseDetails2.getIdentity())) != null && !databaseDetails.isStub()) continue;
            databases.put(identity, databaseDetails2);
        }
        DatabaseDetails.upsert(databases, this.getBatchSize(), this.isUpdateOnly());
        LinkedHashMap<String, SchemaDetails> schemas = new LinkedHashMap<String, SchemaDetails>();
        for (Map<String, String> map : data) {
            String string;
            SchemaDetails existing;
            SchemaDetails details = SchemaDetails.getFromRow(connectionCache, map, this.getDelimiter());
            if (details == null || (existing = (SchemaDetails)schemas.get(string = details.getIdentity())) != null && !existing.isStub()) continue;
            schemas.put(string, details);
        }
        Set<String> set = SchemaDetails.upsert(schemas, this.getBatchSize(), this.isUpdateOnly());
        LinkedHashMap<String, ContainerDetails> linkedHashMap = new LinkedHashMap<String, ContainerDetails>();
        for (Map map : data) {
            String identity;
            Object existing;
            ContainerDetails details = ContainerDetails.getFromRow(connectionCache, (Map<String, String>)map, this.getDelimiter());
            if (details == null || (existing = (ContainerDetails)linkedHashMap.get(identity = details.getIdentity())) != null && !((AssetDetails)existing).isStub()) continue;
            linkedHashMap.put(identity, details);
        }
        Set<String> schemaCountsToUpdate = ContainerDetails.upsert(linkedHashMap, this.getBatchSize(), this.isUpdateOnly());
        boolean bl = true;
        String lastTableQN = null;
        LinkedHashMap<String, ColumnDetails> columns = new LinkedHashMap<String, ColumnDetails>();
        for (Map map : data) {
            int n;
            String tableQN = ContainerDetails.getQualifiedName(connectionCache, map);
            if (lastTableQN == null || !lastTableQN.equals(tableQN)) {
                n = 1;
                lastTableQN = tableQN;
            } else {
                ++n;
            }
            ColumnDetails columnDetails = ColumnDetails.getFromRow(connectionCache, map, this.getDelimiter(), n);
            if (columnDetails != null) {
                String string = columnDetails.getIdentity();
                ColumnDetails existing = columns.put(string, columnDetails);
                if (existing == null) continue;
                log.warn("Duplicate columns found, keeping only the last one defined: {}", (Object)string);
                continue;
            }
            --n;
        }
        Set<ContainerDetails> containerCountsToUpdate = ColumnDetails.upsert(columns, this.getBatchSize(), this.isUpdateOnly());
        log.info("Updating assets with counts...");
        AssetBatch assetBatch = new AssetBatch("Database", this.getBatchSize());
        for (String string : set) {
            try {
                Database database = Database.retrieveByQualifiedName((String)string);
                int schemaCount = database.getSchemas().size();
                Database toUpdate2 = database.trimToRequired().schemaCount(Integer.valueOf(schemaCount)).build();
                assetBatch.add((Asset)toUpdate2);
            }
            catch (AtlanException atlanException) {
                log.error("Unable to re-calculate schemas in database: {}", (Object)string, (Object)atlanException);
            }
        }
        try {
            assetBatch.flush();
        }
        catch (AtlanException e) {
            log.error("Unable to update schema counts for all databases.", (Throwable)e);
        }
        AssetBatch schemasToUpdate = new AssetBatch("Schema", this.getBatchSize());
        for (String string : schemaCountsToUpdate) {
            try {
                Schema complete = Schema.retrieveByQualifiedName((String)string);
                int tableCount = complete.getTables().size();
                int viewCount = complete.getViews().size();
                toUpdate = complete.trimToRequired().tableCount(Integer.valueOf(tableCount)).viewCount(Integer.valueOf(viewCount)).build();
                schemasToUpdate.add((Asset)toUpdate);
            }
            catch (AtlanException e) {
                log.error("Unable to re-calculate tables and views in schema: {}", (Object)string, (Object)e);
            }
        }
        try {
            schemasToUpdate.flush();
        }
        catch (AtlanException atlanException) {
            log.error("Unable to update table and view counts for all schemas.", (Throwable)atlanException);
        }
        AssetBatch assetBatch2 = new AssetBatch("container", this.getBatchSize());
        for (ContainerDetails container : containerCountsToUpdate) {
            String containerType = container.getType();
            String containerQN = container.getName();
            try {
                toUpdate = null;
                switch (containerType) {
                    case "Table": {
                        Table table = Table.retrieveByQualifiedName((String)containerQN);
                        long tc = table.getColumns().size();
                        toUpdate = table.trimToRequired().columnCount(Long.valueOf(tc)).build();
                        break;
                    }
                    case "View": {
                        View view = View.retrieveByQualifiedName((String)containerQN);
                        long vc = view.getColumns().size();
                        toUpdate = view.trimToRequired().columnCount(Long.valueOf(vc)).build();
                        break;
                    }
                    case "MaterialisedView": {
                        MaterializedView mv = MaterializedView.retrieveByQualifiedName((String)containerQN);
                        long mvc = mv.getColumns().size();
                        toUpdate = mv.trimToRequired().columnCount(Long.valueOf(mvc)).build();
                        break;
                    }
                    default: {
                        log.error("Unknown parent container type, cannot update counts: {}", (Object)containerType);
                    }
                }
                if (toUpdate == null) continue;
                assetBatch2.add((Asset)toUpdate);
            }
            catch (AtlanException e) {
                log.error("Unable to re-calculate columns in container: {}", (Object)containerQN, (Object)e);
            }
        }
        try {
            assetBatch2.flush();
        }
        catch (AtlanException atlanException) {
            log.error("Unable to update column counts for all tables and views.", (Throwable)atlanException);
        }
    }

    public void processObjectStoreAssets(ExcelReader xlsx) throws IOException {
        log.info("Loading object store assets from: {}::{}", (Object)this.getFilename(), (Object)OBJECT_SHEET);
        List<Map<String, String>> data = xlsx.getRowsFromSheet(OBJECT_SHEET, 1);
        LinkedHashMap<String, ConnectionDetails> connections = new LinkedHashMap<String, ConnectionDetails>();
        for (Map<String, String> row : data) {
            String string;
            ConnectionDetails connectionDetails;
            ConnectionDetails details = ConnectionDetails.getFromRow(row, this.getDelimiter());
            if (details == null || (connectionDetails = (ConnectionDetails)connections.get(string = details.getIdentity())) != null && !connectionDetails.isStub()) continue;
            connections.put(string, details);
        }
        Map<ConnectionDetails, String> connectionCache = ConnectionDetails.upsert(connections, this.getBatchSize(), this.isUpdateOnly());
        LinkedHashMap<String, AccountDetails> accounts = new LinkedHashMap<String, AccountDetails>();
        for (Map map : data) {
            String string;
            AccountDetails existing;
            AccountDetails accountDetails = AccountDetails.getFromRow(connectionCache, (Map<String, String>)map, this.getDelimiter());
            if (accountDetails == null || (existing = (AccountDetails)accounts.get(string = accountDetails.getIdentity())) != null && !existing.isStub()) continue;
            accounts.put(string, accountDetails);
        }
        AccountDetails.upsert(accounts, this.getBatchSize(), this.isUpdateOnly());
        LinkedHashMap<String, BucketDetails> buckets = new LinkedHashMap<String, BucketDetails>();
        for (Map<String, String> map : data) {
            String identity;
            BucketDetails existing;
            BucketDetails bucketDetails = BucketDetails.getFromRow(connectionCache, map, this.getDelimiter());
            if (bucketDetails == null || (existing = (BucketDetails)buckets.get(identity = bucketDetails.getIdentity())) != null && !existing.isStub()) continue;
            buckets.put(identity, bucketDetails);
        }
        BucketDetails.upsert(buckets, this.getBatchSize(), this.isUpdateOnly());
        LinkedHashMap<String, ObjectDetails> linkedHashMap = new LinkedHashMap<String, ObjectDetails>();
        for (Map<String, String> map : data) {
            String identity;
            ObjectDetails existing;
            ObjectDetails details = ObjectDetails.getFromRow(connectionCache, map, this.getDelimiter());
            if (details == null || (existing = (ObjectDetails)linkedHashMap.get(identity = details.getIdentity())) != null && !existing.isStub()) continue;
            linkedHashMap.put(identity, details);
        }
        Set<String> set = ObjectDetails.upsert(linkedHashMap, this.getBatchSize(), this.isUpdateOnly());
        log.info("Updating assets with counts...");
        AssetBatch assetBatch = new AssetBatch("bucket", this.getBatchSize());
        for (String bucketQualifiedName : set) {
            try {
                AtlanConnectorType type = Connection.getConnectorTypeFromQualifiedName((String)bucketQualifiedName);
                switch (type) {
                    case S3: {
                        S3Bucket s3f = S3Bucket.retrieveByQualifiedName((String)bucketQualifiedName);
                        long s3c = s3f.getObjects().size();
                        S3Bucket s3u = s3f.trimToRequired().s3ObjectCount(Long.valueOf(s3c)).build();
                        assetBatch.add((Asset)s3u);
                        break;
                    }
                    case GCS: {
                        GCSBucket gcsf = GCSBucket.retrieveByQualifiedName((String)bucketQualifiedName);
                        long gcsc = gcsf.getGcsObjects().size();
                        GCSBucket gcsu = gcsf.trimToRequired().gcsObjectCount(Long.valueOf(gcsc)).build();
                        assetBatch.add((Asset)gcsu);
                        break;
                    }
                    case ADLS: {
                        break;
                    }
                    default: {
                        log.error("Invalid connector type found for an object store bucket: {}", (Object)type);
                        break;
                    }
                }
            }
            catch (AtlanException e) {
                log.error("Unable to re-calculate objects in bucket: {}", (Object)bucketQualifiedName, (Object)e);
            }
        }
        try {
            assetBatch.flush();
        }
        catch (AtlanException e) {
            log.error("Unable to update object counts for all buckets.", (Throwable)e);
        }
    }

    public void processLineage(ExcelReader xlsx) throws IOException {
        log.info("Loading lineage from: {}::{}", (Object)this.getFilename(), (Object)LINEAGE_SHEET);
        List<Map<String, String>> data = xlsx.getRowsFromSheet(LINEAGE_SHEET, 1);
        LinkedHashMap<String, ConnectionDetails> connections = new LinkedHashMap<String, ConnectionDetails>();
        for (Map<String, String> row : data) {
            String identity;
            ConnectionDetails existing;
            ConnectionDetails connectionDetails = LineageDetails.getOrchestratorFromRow(row);
            if (connectionDetails == null || (existing = (ConnectionDetails)connections.get(identity = connectionDetails.getIdentity())) != null && !existing.isStub()) continue;
            connections.put(identity, connectionDetails);
        }
        Map<ConnectionDetails, String> connectionCache = ConnectionDetails.upsert(connections, this.getBatchSize(), this.isUpdateOnly());
        for (Map map : data) {
            ConnectionDetails target;
            ConnectionDetails source = LineageDetails.getSourceConnectionFromRow(map);
            if (source != null) {
                try {
                    ConnectionDetails.findAndCache(connectionCache, source.getName(), source.getType());
                }
                catch (AtlanException e) {
                    log.error("Unable to find source connection: {}", (Object)source, (Object)e);
                }
            }
            if ((target = LineageDetails.getTargetConnectionFromRow(map)) == null) continue;
            try {
                ConnectionDetails.findAndCache(connectionCache, target.getName(), target.getType());
            }
            catch (AtlanException e) {
                log.error("Unable to find target connection: {}", (Object)target, (Object)e);
            }
        }
        LinkedHashMap<String, Set<LineageDetails>> lineage = new LinkedHashMap<String, Set<LineageDetails>>();
        for (Map<String, String> row : data) {
            LineageDetails details = LineageDetails.getFromRow(connectionCache, row, this.getDelimiter());
            if (details == null) continue;
            String processQN = details.getProcessConnectionQualifiedName() + "/" + details.getProcessId();
            if (!lineage.containsKey(processQN)) {
                lineage.put(processQN, new LinkedHashSet());
            }
            ((Set)lineage.get(processQN)).add(details);
        }
        LineageDetails.upsert(lineage, this.getBatchSize());
    }
}

