/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.atlan.cache.RoleCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.APIPath;
import com.atlan.model.assets.APISpec;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Connection;
import com.atlan.model.core.AssetMutationResponse;
import com.atlan.model.core.ConnectionCreationResponse;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.samples.loaders.AbstractLoader;
import com.atlan.samples.readers.OpenAPISpecReader;
import com.atlan.util.AssetBatch;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPISpecLoader
extends AbstractLoader
implements RequestHandler<Map<String, String>, String> {
    private static final Logger log = LoggerFactory.getLogger(OpenAPISpecLoader.class);
    private String _specUrl = null;
    private String _apiName = null;

    public static void main(String[] args) {
        OpenAPISpecLoader sl = new OpenAPISpecLoader();
        sl.handleRequest(System.getenv(), null);
    }

    @Override
    protected void parseParametersFromEvent(Map<String, String> event) {
        super.parseParametersFromEvent(event);
        if (event != null) {
            String apiName;
            String specUrl = event.getOrDefault("API_SPEC_URL", null);
            if (specUrl != null) {
                this._specUrl = specUrl;
            }
            if ((apiName = (String)event.getOrDefault("API_NAME", null)) != null) {
                this._apiName = apiName;
            }
        }
    }

    public String handleRequest(Map<String, String> event, Context context) {
        ConnectionCreationResponse response;
        log.info("Retrieving configuration and context...");
        if (context != null && context.getClientContext() != null) {
            log.debug(" ... client environment: {}", (Object)context.getClientContext().getEnvironment());
            log.debug(" ... client custom: {}", (Object)context.getClientContext().getCustom());
        }
        this.parseParametersFromEvent(event);
        if (this._apiName == null || this._specUrl == null) {
            log.error("Missing key inputs \u2014 must have both API_SPEC_URL ({}) and API_NAME ({}) defined.", (Object)this._apiName, (Object)this._specUrl);
            System.exit(1);
        }
        log.info("Loading definitions from: {}", (Object)this._specUrl);
        OpenAPISpecReader parser = new OpenAPISpecReader(this._specUrl);
        String connectionQualifiedName = null;
        log.info("Looking for existing API connection named: {}", (Object)this._apiName);
        try {
            List found = Connection.findByName((String)this._apiName, (AtlanConnectorType)AtlanConnectorType.API, null);
            if (found.size() > 1) {
                log.warn("... found multiple API connections with name {}", (Object)this._apiName);
            }
            connectionQualifiedName = ((Connection)found.get(0)).getQualifiedName();
            log.info("... re-using: {} ({})", (Object)this._apiName, (Object)connectionQualifiedName);
        }
        catch (NotFoundException e) {
            try {
                log.info("... none found, creating a new API connection...");
                Connection connectionToCreate = Connection.creator((String)this._apiName, (AtlanConnectorType)AtlanConnectorType.API, List.of(RoleCache.getIdForName((String)"$admin")), null, null).build();
                response = connectionToCreate.upsert();
                if (response != null && response.getCreatedAssets().size() == 1) {
                    connectionQualifiedName = ((Asset)response.getCreatedAssets().get(0)).getQualifiedName();
                    log.info("... created connection: {}", (Object)connectionQualifiedName);
                }
            }
            catch (AtlanException create) {
                log.error("Unable to create a connection for the API.", (Throwable)create);
                System.exit(1);
            }
        }
        catch (AtlanException find) {
            log.error("Unable to even attempt to find an existing connection for the API.", (Throwable)find);
            System.exit(1);
        }
        if (connectionQualifiedName == null) {
            log.error("Unable to find an existing or create a new connection for the API.");
            System.exit(1);
        }
        try {
            Asset.retrieveMinimal((String)"Connection", connectionQualifiedName);
        }
        catch (AtlanException e) {
            log.error("Unable to retrieve the connection for the API.", (Throwable)e);
            System.exit(1);
        }
        String specQualifiedName = null;
        try {
            APISpec specToCreate = ((APISpec.APISpecBuilder)((APISpec.APISpecBuilder)APISpec.creator((String)parser.getTitle(), (String)connectionQualifiedName).sourceURL(this._specUrl)).apiSpecType(parser.getOpenAPIVersion()).description(parser.getDescription())).apiSpecTermsOfServiceURL(parser.getTermsOfServiceURL()).apiSpecContactEmail(parser.getContactEmail()).apiSpecContactName(parser.getContactName()).apiSpecContactURL(parser.getContactURL()).apiSpecLicenseName(parser.getLicenseName()).apiSpecLicenseURL(parser.getLicenseURL()).apiSpecVersion(parser.getVersion()).apiExternalDoc("url", parser.getExternalDocsURL()).apiExternalDoc("description", parser.getExternalDocsDescription()).build();
            log.info("Upserting APISpec: {}", (Object)specToCreate.getQualifiedName());
            response = specToCreate.upsert();
            if (response != null) {
                if (response.getCreatedAssets().size() == 1) {
                    specQualifiedName = ((Asset)response.getCreatedAssets().get(0)).getQualifiedName();
                    log.info("... created APISpec: {}", (Object)specQualifiedName);
                } else if (response.getUpdatedAssets().size() == 1) {
                    specQualifiedName = ((Asset)response.getUpdatedAssets().get(0)).getQualifiedName();
                    log.info("... updated APISpec: {}", (Object)specQualifiedName);
                } else {
                    specQualifiedName = specToCreate.getQualifiedName();
                    log.info("... reusing existing APISpec: {}", (Object)specQualifiedName);
                }
            }
        }
        catch (AtlanException e) {
            log.error("Unable to upsert APISpec.", (Throwable)e);
            System.exit(1);
        }
        AssetBatch batch = new AssetBatch("APIPath", this.getBatchSize());
        Paths apiPaths = parser.getPaths();
        if (apiPaths != null && !apiPaths.isEmpty()) {
            log.info("Creating an APIPath for each path defined within the spec: {}", (Object)apiPaths.size());
            try {
                for (Map.Entry apiPath : apiPaths.entrySet()) {
                    Operation delete;
                    Operation patch;
                    Operation put;
                    Operation post;
                    String pathUrl = (String)apiPath.getKey();
                    PathItem pathDetails = (PathItem)apiPath.getValue();
                    ArrayList<String> operations = new ArrayList<String>();
                    StringBuilder desc = new StringBuilder();
                    desc.append("| Method | Summary |\n|---|---|\n");
                    Operation get = pathDetails.getGet();
                    if (get != null) {
                        operations.add("GET");
                        desc.append("| `GET` | ").append(get.getSummary()).append(" |\n");
                    }
                    if ((post = pathDetails.getPost()) != null) {
                        operations.add("POST");
                        desc.append("| `POST` | ").append(post.getSummary()).append(" |\n");
                    }
                    if ((put = pathDetails.getPut()) != null) {
                        operations.add("PUT");
                        desc.append("| `PUT` | ").append(put.getSummary()).append(" |\n");
                    }
                    if ((patch = pathDetails.getPatch()) != null) {
                        operations.add("PATCH");
                        desc.append("| `PATCH` | ").append(patch.getSummary()).append(" |\n");
                    }
                    if ((delete = pathDetails.getDelete()) != null) {
                        operations.add("DELETE");
                        desc.append("| `DELETE` | ").append(delete.getSummary()).append(" |\n");
                    }
                    APIPath path = ((APIPath.APIPathBuilder)APIPath.creator((String)pathUrl, (String)specQualifiedName).description(desc.toString())).apiPathRawURI(pathUrl).apiPathSummary(pathDetails.getSummary()).apiPathAvailableOperations(operations).apiPathIsTemplated(Boolean.valueOf(pathUrl.contains("{") && pathUrl.contains("}"))).build();
                    this.logResult(batch.add((Asset)path));
                }
                this.logResult(batch.flush());
            }
            catch (AtlanException e) {
                log.error("Unable to bulk-upsert API paths.", (Throwable)e);
            }
        }
        return this._specUrl;
    }

    private void logResult(AssetMutationResponse response) {
        if (response != null) {
            List createdList = response.getCreatedAssets();
            for (Asset created : createdList) {
                log.info("...... created: {}: {}", (Object)created.getTypeName(), (Object)created.getQualifiedName());
            }
            List updatedList = response.getUpdatedAssets();
            for (Asset updated : updatedList) {
                log.info("...... updated: {}: {}", (Object)updated.getTypeName(), (Object)updated.getQualifiedName());
            }
        }
    }
}

