/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders.caches;

import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.GlossaryCategory;
import com.atlan.samples.loaders.caches.AssetCache;
import com.atlan.samples.loaders.models.CategoryEnrichmentDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryCache
extends AssetCache {
    private static final Logger log = LoggerFactory.getLogger(CategoryCache.class);

    @Override
    protected Asset lookupAsset(String identity) {
        String categoryPath = CategoryEnrichmentDetails.getPathFromIdentity(identity);
        String categoryName = CategoryEnrichmentDetails.getNameFromPath(categoryPath);
        String glossaryName = CategoryEnrichmentDetails.getGlossaryNameFromIdentity(identity);
        try {
            return GlossaryCategory.findByName((String)categoryName, (String)glossaryName, null);
        }
        catch (AtlanException e) {
            log.error("Unable to lookup or find category: {}", (Object)identity, (Object)e);
            return null;
        }
    }
}

